/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkTriggerOutputMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataFactory;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.AbstractSdkTriggerLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.MuleAnnotationsUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.data.sample.SampleData;

public class SdkTriggerImplementationLayer
extends AbstractSdkTriggerLayer {
    public static final String PARAM_DOC_NAME_DESCRIPTION = "@param $L $L\n";
    private final TypeName superclass;
    private final SdkTriggerOutputMetadataResolver outputMetadataResolver;
    private final List<SdkParameter> sdkParameters;
    private SdkResolverTemplate sdkSampleDataProvider;

    public SdkTriggerImplementationLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, String javaClassName, String packageName, TypeName superclass, List<SdkParameter> sdkParameters, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, trigger, javaClassName, packageName, runConfiguration);
        this.superclass = superclass;
        this.outputMetadataResolver = this.buildOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger, runConfiguration);
        this.sdkParameters = sdkParameters;
    }

    private SdkTriggerOutputMetadataResolver buildOutputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        return trigger.getTriggerOutputType() != null ? new SdkTriggerOutputMetadataResolver(outputDir, connectorModel, sdkConnector, trigger.getInternalName(), trigger.getTriggerOutputType(), trigger.getName(), runConfiguration) : null;
    }

    private void generateTriggerClass() throws TemplatingException {
        CodeBlock.Builder javaDoc = CodeBlock.builder().add("\n$L\n", new Object[]{StringUtils.defaultIfEmpty((CharSequence)this.trigger.getDescription(), (CharSequence)this.trigger.getDisplayName())}).add("\n", new Object[0]);
        for (SdkParameter parameter : this.sdkParameters) {
            javaDoc.add(PARAM_DOC_NAME_DESCRIPTION, new Object[]{parameter.getExternalName(), StringUtils.defaultIfEmpty((CharSequence)parameter.getDescription(), (CharSequence)parameter.getDisplayName())});
        }
        TypeSpec.Builder triggerClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass).addAnnotation(this.generateDisplayNameAnnotation()).addJavadoc(javaDoc.build());
        if (this.trigger.getTriggerOutputType() != null || StringUtils.isNotBlank((CharSequence)this.trigger.getOutputMediaType())) {
            triggerClassBuilder.addAnnotation(this.generateMediaTypeAnnotation());
        }
        if (this.trigger.getAlias() != null) {
            triggerClassBuilder.addAnnotation(this.generateAliasAnnotation());
        }
        this.sdkSampleDataProvider = this.buildSampleData();
        if (this.sdkSampleDataProvider != null) {
            this.addSampleDataAnnotation(triggerClassBuilder);
        }
        triggerClassBuilder.addAnnotation(this.getMetadataScopeAnnotation());
        if (this.trigger.isSidecar()) {
            triggerClassBuilder.addAnnotation(this.generateSidecarAnnotation());
        }
        JavaFile.Builder javaFileBuilder = this.getJavaFileBuilderForClass(triggerClassBuilder.build(), this.getPackage());
        this.writeJavaFile(javaFileBuilder.build());
    }

    private AnnotationSpec generateMediaTypeAnnotation() {
        javax.ws.rs.core.MediaType mediaType;
        javax.ws.rs.core.MediaType mediaType2 = mediaType = this.trigger.getTriggerOutputType() != null ? this.trigger.getTriggerOutputType().getMediaType() : javax.ws.rs.core.MediaType.valueOf((String)this.trigger.getOutputMediaType());
        if (mediaType == null) {
            throw new IllegalArgumentException(String.format("Failed to set MediaType for the Trigger %s", this.trigger.getName()));
        }
        return AnnotationSpec.builder(MediaType.class).addMember("value", "$S", new Object[]{mediaType}).build();
    }

    private AnnotationSpec getMetadataScopeAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(MetadataScope.class);
        if (this.outputMetadataResolver != null && this.outputMetadataResolver.getRequiresMetadataResolver()) {
            builder.addMember("outputResolver", "$T.class", new Object[]{ClassName.get((String)this.outputMetadataResolver.getPackage(), (String)this.outputMetadataResolver.getClassName(), (String[])new String[0])});
        } else if (StringUtils.isNotBlank((CharSequence)this.trigger.getMuleMetadataScope())) {
            this.trigger.getParameters().stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getMuleMetadataKeyId())).findFirst().ifPresent(p -> builder.addMember("keysResolver", "$T.class", new Object[]{MuleAnnotationsUtils.getClassName(p.getMuleMetadataKeyId())}));
            builder.addMember("outputResolver", "$T.class", new Object[]{MuleAnnotationsUtils.getClassName(this.trigger.getMuleMetadataScope())});
        }
        builder.addMember("attributesResolver", "$T.class", new Object[]{this.sdkConnector.getOutputAttributesResolver()});
        return builder.build();
    }

    private AnnotationSpec generateSidecarAnnotation() {
        return AnnotationSpec.builder(Ignore.class).build();
    }

    private AnnotationSpec generateDisplayNameAnnotation() {
        return AnnotationSpec.builder(DisplayName.class).addMember("value", "$S", new Object[]{this.trigger.getDisplayName()}).build();
    }

    private AnnotationSpec generateAliasAnnotation() {
        return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{this.trigger.getAlias()}).build();
    }

    private SdkResolverTemplate buildSampleData() {
        return SdkSampleDataFactory.getSdkSampleDataResolver(this.trigger, this.connectorModel, this.sdkConnector, this.getJavaClassName(), this.sdkParameters, this.outputDir, this.runConfiguration);
    }

    private void addSampleDataAnnotation(TypeSpec.Builder triggerClassBuilder) {
        if (this.sdkSampleDataProvider != null) {
            AnnotationSpec sampleDataAnnotation = AnnotationSpec.builder(SampleData.class).addMember("value", "$T.class", new Object[]{this.sdkSampleDataProvider.getTypeName()}).build();
            triggerClassBuilder.addAnnotation(sampleDataAnnotation);
        }
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateTriggerClass();
        if (this.outputMetadataResolver != null) {
            this.outputMetadataResolver.applyTemplates();
        }
        if (this.sdkSampleDataProvider != null) {
            this.sdkSampleDataProvider.applyTemplates();
        }
    }
}

