/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger.layers.AbstractSdkTriggerLayer;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;

public class SdkTriggerRefinementLayer
extends AbstractSdkTriggerLayer {
    public static final String REFINEMENT_LAYER_JAVADOC = "This refinement is the middle layer of the trigger generation gap pattern. It can be overridden to add custom logic in the trigger.";
    private final TypeName baseClass;

    public SdkTriggerRefinementLayer(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, Trigger trigger, String javaClassName, String packageName, TypeName baseClass, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, sdkConnector, trigger, javaClassName, packageName, runConfiguration);
        this.baseClass = baseClass;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateClass();
    }

    private void generateClass() throws TemplatingException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass(this.baseClass).addJavadoc(REFINEMENT_LAYER_JAVADOC, new Object[0]);
        this.writeClassToFile(classBuilder.build(), this.getPackage(), true, this.trigger.isRefined());
    }

    @Override
    public String getJavaClassName() {
        return super.getJavaClassName() + "Refinement";
    }

    @Override
    public String getPackage() {
        return super.getPackage() + ".refinement";
    }
}

