/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.exception;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;

/**
 * There was a user error in the provided API spec.
 */
public class MalformedSpecException extends ModelGenerationException {

  private final APILocation location;

  public MalformedSpecException(String message, APILocation location) {
    super(message + ", at " + location);
    this.location = location;
  }

  public APILocation getLocation() {
    return location;
  }
}
