/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

public class APIDocumentationModel {

  private final String description;
  private final String url;
  private final APILocation location;

  public APIDocumentationModel(String description, String url, APILocation location) {
    this.description = description;
    this.url = url;
    this.location = location;
  }

  public String getDescription() {
    return description;
  }

  public String getUrl() {
    return url;
  }

  /**
   * Retrieves the location in the API Spec this element was parsed from.
   */
  public APILocation getLocation() {
    return location;
  }
}
