/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import java.util.Objects;

public class APIPosition {

  final private int line;
  final private int column;

  public APIPosition(int line, int column) {
    this.line = line;
    this.column = column;
  }

  public int getLine() {
    return line;
  }

  public int getColumn() {
    return column;
  }

  @Override
  public String toString() {
    return line + ";" + column;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof APIPosition))
      return false;
    APIPosition position = (APIPosition) o;
    return line == position.line && column == position.column;
  }

  @Override
  public int hashCode() {
    return Objects.hash(line, column);
  }

  public static APIPosition from(org.mulesoft.common.client.lexical.Position position) {
    return new APIPosition(position.line(), position.column());
  }
}
