/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFAPIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFAPIModelFactory;

import java.io.File;

public class ApiParser {

  private ApiParser() {}

  public static APIModel parseModel(File spec, boolean skipValidations)
      throws ModelGenerationException {
    return new AMFAPIModelFactory().build(spec.toPath(), skipValidations);
  }
}
