/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.util;

import static java.util.regex.Pattern.compile;
import static org.apache.commons.lang3.StringUtils.isBlank;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParserUtils {

  private static final Pattern LOWER_UPPER_CASE_PATTERN = compile("([a-z])([A-Z])");

  public static String splitCaps(String string, String split) {
    return LOWER_UPPER_CASE_PATTERN.matcher(string).replaceAll("$1" + split + "$2");
  }

  private static final Pattern HTML_TAG_PATTERN = compile("<([a-zA-Z]*)(?:\\s[^>]*)*>(.*?)</(?:\\1)>");

  public static String removeHtmlTags(String string) {
    if (isBlank(string)) {
      return string;
    }

    Matcher matcher = HTML_TAG_PATTERN.matcher(string);

    while (matcher.find()) {
      string = matcher.replaceAll("$2");
      matcher = HTML_TAG_PATTERN.matcher(string);
    }

    return string;
  }

}
