/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.model;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public abstract class APIModel {
    private final String apiName;
    private final String description;
    private final String baseUri;
    private final String apiVersion;
    private final List<APIOperationModel> operationsModel;
    private final List<String> protocols;
    private final Map<String, APIOperationModel> operationsByOperationId = new HashMap<String, APIOperationModel>();
    private final Map<Pair<String, String>, APIOperationModel> operationsByMethodAndPath = new HashMap<Pair<String, String>, APIOperationModel>();

    public APIModel(String apiName, String description, String baseUri, String apiVersion, List<APIOperationModel> operations, List<String> protocols) {
        this.apiName = apiName;
        this.description = description;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.operationsModel = operations;
        this.protocols = protocols;
        for (APIOperationModel apiOperationModel : operations) {
            APIOperationModel prev = this.operationsByMethodAndPath.put((Pair<String, String>)Pair.of((Object)apiOperationModel.getHttpMethod().toLowerCase(Locale.ROOT), (Object)apiOperationModel.getPath().toLowerCase(Locale.ROOT)), apiOperationModel);
            if (prev != null) {
                throw new IllegalStateException("There are more than one operation with same path and http method, but different case. One of them has path '" + prev.getPath() + "' and method '" + prev.getHttpMethod() + "'");
            }
            String operationId = apiOperationModel.getOperationId();
            if (operationId == null) continue;
            this.operationsByOperationId.put(operationId, apiOperationModel);
        }
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public List<APIOperationModel> getOperationsModel() {
        return this.operationsModel;
    }

    public abstract APILocation getLocation();

    public Optional<APIOperationModel> findOperation(String operationId) {
        return Optional.ofNullable(this.operationsByOperationId.get(Objects.requireNonNull(operationId, "operationId must not be null")));
    }

    public Optional<APIOperationModel> findOperation(String path, String method) {
        return Optional.ofNullable(this.operationsByMethodAndPath.get(Pair.of((Object)Objects.requireNonNull(method, "method must not be null").toLowerCase(Locale.ROOT), (Object)Objects.requireNonNull(path, "path must not be null").toLowerCase(Locale.ROOT))));
    }
}

