/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.domain.Graph;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFOperationModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AMFAPIModel
extends APIModel {
    private final WebApi webApi;

    public AMFAPIModel(WebApi webApi, boolean isRaml) throws ModelGenerationException {
        super(AMFAPIModel.buildApiName(webApi), AMFAPIModel.buildDescription(webApi), AMFAPIModel.buildBaseUri(webApi), AMFAPIModel.buildApiVersion(webApi), AMFAPIModel.buildOperationsModel(webApi, isRaml), AMFAPIModel.buildProtocols(webApi));
        this.webApi = webApi;
    }

    private static String buildApiName(WebApi webApi) {
        return webApi.name().value();
    }

    private static String buildDescription(WebApi webApi) {
        StrField description = webApi.description();
        return description.nonEmpty() ? description.value() : "";
    }

    private static String buildApiVersion(WebApi webApi) {
        StrField version = webApi.version();
        return version != null ? version.value() : null;
    }

    private static String buildBaseUri(WebApi webApi) {
        return webApi.servers().stream().filter(x -> x.url().nonEmpty()).findFirst().map(server -> server.url().value()).orElse(null);
    }

    private static List<String> buildProtocols(WebApi webApi) {
        return webApi.schemes().stream().map(StrField::value).collect(Collectors.toList());
    }

    private static List<APIOperationModel> buildOperationsModel(WebApi webApi, boolean isRaml) throws ModelGenerationException {
        ArrayList<AMFOperationModel> operationsModel = new ArrayList<AMFOperationModel>();
        for (EndPoint endPoint : webApi.endPoints()) {
            for (Operation operation : endPoint.operations()) {
                operationsModel.add(new AMFOperationModel(endPoint, operation, isRaml));
            }
        }
        return Collections.unmodifiableList(operationsModel);
    }

    public Graph graph() {
        return this.webApi.graph();
    }

    @Override
    public APILocation getLocation() {
        return APILocation.from(this.webApi.annotations());
    }
}

