/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.Response;
import amf.apicontract.client.platform.model.domain.security.OAuth2Flow;
import amf.apicontract.client.platform.model.domain.security.OAuth2Settings;
import amf.apicontract.client.platform.model.domain.security.ParametrizedSecurityScheme;
import amf.apicontract.client.platform.model.domain.security.SecurityRequirement;
import amf.apicontract.client.platform.model.domain.security.SecurityScheme;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.domain.DomainElement;
import amf.core.client.platform.model.domain.Graph;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.CreativeWork;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.UnsupportedSecuritySchemeException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIDocumentationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFSecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.security.AMFSecuritySchemesNaming;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AMFOperationModel
extends APIOperationModel {
    private final EndPoint endPoint;
    private final Operation operation;
    private final boolean isRaml;

    public AMFOperationModel(EndPoint endPoint, Operation operation, boolean isRaml) throws ModelGenerationException {
        this.endPoint = endPoint;
        this.operation = operation;
        this.isRaml = isRaml;
        this.description = this.buildOperationDescription();
        this.summary = operation.summary().value();
        this.path = this.buildOperationPath();
        this.httpMethod = operation.method().value();
        this.baseUris = operation.servers().stream().filter(s -> s.url() != null).map(s -> s.url().value()).collect(Collectors.toList());
        this.name = this.buildName();
        this.operationId = operation.operationId().value();
        this.uriParamsModel = this.buildUriParamsModel();
        this.queryParamsModel = this.buildQueryParamsModel();
        this.headersModel = this.buildHeadersModel();
        this.inputMetadataModel = this.buildInputMetadataModels();
        this.outputMetadataModel = this.buildOutputMetadataModels();
        this.securitySchemesModel = this.buildSecuritySchemesModel();
        this.apiDocumentationModel = this.buildDocumentationModel();
    }

    private APIDocumentationModel buildDocumentationModel() {
        CreativeWork documentation = this.operation.documentation();
        if (documentation == null) {
            return null;
        }
        String url = this.isRaml ? documentation.title().value() : documentation.url().value();
        return new APIDocumentationModel(documentation.description().value(), url, APILocation.from(documentation.annotations()));
    }

    private List<APISecuritySchemeModel> buildSecuritySchemesModel() throws ModelGenerationException {
        List endPointSecurityRequirements = this.endPoint.security();
        List operationSecurityRequirements = this.operation.security();
        List selectedRequirements = this.selectSecurityRequirements(operationSecurityRequirements, endPointSecurityRequirements, new ArrayList()).stream().filter(x -> !x.schemes().isEmpty()).collect(Collectors.toList());
        List selectedRequirementsMultipleSchemes = selectedRequirements.stream().filter(x -> x.schemes().size() > 1 && this.notNullSchemes(x.schemes())).collect(Collectors.toList());
        List selectedRequirementsSimpleSchemes = selectedRequirements.stream().filter(x -> x.schemes().size() == 1 && this.notNullSchemes(x.schemes())).collect(Collectors.toList());
        ArrayList<APISecuritySchemeModel> securitySchemesModel = new ArrayList<APISecuritySchemeModel>();
        for (SecurityRequirement securityRequirement : selectedRequirementsMultipleSchemes) {
            if (!securityRequirement.schemes().stream().allMatch(x -> AMFSecuritySchemesNaming.isApiKey(x.scheme().type().value()))) continue;
            securitySchemesModel.add(new AMFSecuritySchemeModel(securityRequirement.schemes().stream().map(x -> x.scheme()).collect(Collectors.toList())));
        }
        for (SecurityRequirement securityRequirement : selectedRequirementsSimpleSchemes) {
            SecurityScheme securityScheme = ((ParametrizedSecurityScheme)securityRequirement.schemes().stream().findFirst().get()).scheme();
            if (securityScheme == null) continue;
            if (AMFSecuritySchemesNaming.isOauth2(securityScheme.type().value())) {
                securitySchemesModel.addAll(((OAuth2Settings)securityScheme.settings()).flows().stream().map(x -> new AMFSecuritySchemeModel(securityScheme, (OAuth2Flow)x)).collect(Collectors.toList()));
                continue;
            }
            securitySchemesModel.add(new AMFSecuritySchemeModel(securityScheme));
        }
        if (!(selectedRequirementsMultipleSchemes.isEmpty() && selectedRequirementsSimpleSchemes.isEmpty() || !securitySchemesModel.isEmpty())) {
            throw new UnsupportedSecuritySchemeException(this.httpMethod + " " + this.path + ": None of the specified security schemes are supported", APILocation.from(this.operation.annotations()));
        }
        return securitySchemesModel;
    }

    private boolean notNullSchemes(List<ParametrizedSecurityScheme> schemes) {
        return schemes.stream().anyMatch(y -> y.scheme() != null);
    }

    private static Stream<SecurityScheme> getSchemes(DomainElement domainElement) {
        if (domainElement instanceof SecurityRequirement) {
            SecurityRequirement securityRequirement = (SecurityRequirement)domainElement;
            return securityRequirement.schemes().stream().map(ParametrizedSecurityScheme::scheme);
        }
        return Stream.empty();
    }

    private List<APITypeModel> buildOutputMetadataModels() {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        ArrayList<APITypeModel> defaultModel = new ArrayList<APITypeModel>();
        if (this.operation.responses() != null) {
            for (Response response : this.operation.responses()) {
                if (!response.statusCode().nonEmpty()) continue;
                if (response.statusCode().value().startsWith("2")) {
                    models.addAll(this.buildAMFTypeModel(response));
                    continue;
                }
                if (!response.statusCode().value().startsWith("default")) continue;
                defaultModel.addAll(this.buildAMFTypeModel(response));
            }
        }
        if (models.isEmpty()) {
            return defaultModel;
        }
        return models;
    }

    private List<APITypeModel> buildAMFTypeModel(Response response) {
        return this.buildIOMetadataModels(response.payloads(), this.operation.contentType(), null, true);
    }

    private List<APITypeModel> buildInputMetadataModels() {
        if (this.operation.request() != null) {
            return this.buildIOMetadataModels(this.operation.request().payloads(), this.operation.accepts(), this.isRaml || this.operation.request().required().value(), false);
        }
        return Collections.emptyList();
    }

    private List<APITypeModel> buildIOMetadataModels(List<Payload> payloads, List<StrField> globalMediaTypes, Boolean required, boolean isResponse) {
        ArrayList<APITypeModel> models = new ArrayList<APITypeModel>();
        if (payloads == null) {
            return models;
        }
        List<String> globalMediaTypesString = globalMediaTypes.stream().map(StrField::value).collect(Collectors.toList());
        for (Payload payload : payloads) {
            if (payload.schema() == null) continue;
            if (payload.mediaType().isNullOrEmpty() && !globalMediaTypesString.isEmpty()) {
                globalMediaTypesString.forEach(x -> models.add(new AMFTypeModel((AnyShape)payload.schema(), (String)x, required, isResponse)));
                continue;
            }
            models.add(new AMFTypeModel((AnyShape)payload.schema(), payload.mediaType().value(), required, isResponse));
        }
        return models;
    }

    private String buildName() {
        if (this.operation.name().nonEmpty() && StringUtils.isNotBlank((CharSequence)this.operation.name().value()) && !this.operation.name().value().equalsIgnoreCase(this.operation.method().value()) && !this.operation.name().value().equalsIgnoreCase(this.operation.operationId().value())) {
            return this.operation.name().value();
        }
        return null;
    }

    private String buildOperationPath() {
        return this.endPoint.path().value();
    }

    private String buildOperationDescription() {
        return this.operation.description().nonEmpty() ? this.operation.description().value() : this.endPoint.description().value();
    }

    private List<APIParameterModel> buildUriParamsModel() {
        AMFParameterModel parameterModel;
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().uriParameters()) {
                parameterModel = new AMFParameterModel(x, APIParameterType.URI, false);
                list.add(parameterModel);
            }
        }
        for (Parameter x : this.endPoint.parameters()) {
            parameterModel = new AMFParameterModel(x, APIParameterType.URI, false);
            list.add(parameterModel);
        }
        return list;
    }

    private List<APIParameterModel> buildQueryParamsModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().queryParameters()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.QUERY, false);
                list.add(parameterModel);
            }
        }
        return list;
    }

    private List<APIParameterModel> buildHeadersModel() {
        ArrayList<APIParameterModel> list = new ArrayList<APIParameterModel>();
        if (this.operation.request() != null) {
            for (Parameter x : this.operation.request().headers()) {
                AMFParameterModel parameterModel = new AMFParameterModel(x, APIParameterType.HEADER, false);
                list.add(parameterModel);
            }
        }
        return list;
    }

    public Graph graph() {
        return this.operation.graph();
    }

    @Override
    public APILocation getLocation() {
        return APILocation.from(this.operation.annotations());
    }
}

