/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.apicontract.client.platform.model.domain.Parameter;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.domain.Graph;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import amf.shapes.client.platform.model.domain.operations.AbstractPayload;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APILocation;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.Objects;

public class AMFParameterModel
extends APIParameterModel {
    private final Parameter parameter;

    public AMFParameterModel(Parameter parameter, APIParameterType parameterType, boolean isPassword) {
        this.parameter = parameter;
        this.externalName = parameter.parameterName().value();
        this.displayName = AMFParameterModel.buildDisplayName(parameter);
        this.parameterType = parameterType;
        this.defaultValue = AMFParameterModel.buildDefaultValue(parameter);
        this.description = AMFParameterModel.buildDescription(parameter);
        this.isPassword = isPassword;
        this.isRequired = parameter.required().value();
        this.summary = AMFParameterModel.buildDisplayName(parameter);
        Shape parameterShape = AMFParameterModel.getParameterShape(parameter);
        this.typeModel = new AMFTypeModel((AnyShape)parameterShape, AMFParameterModel.getDefaultMediaType(parameterShape), parameter.required().value(), false);
    }

    private static String buildDisplayName(Parameter parameter) {
        StrField displayName = AMFParameterModel.getParameterShape(parameter).displayName();
        return displayName.isNullOrEmpty() ? null : ParserUtils.removeHtmlTags(displayName.value());
    }

    private static String buildDescription(Parameter parameter) {
        return parameter.description().value();
    }

    public AMFParameterModel(PropertyShape propertyShape, APIParameterType parameterType) {
        this.externalName = propertyShape.id().substring(propertyShape.id().lastIndexOf(47) + 1);
        this.displayName = propertyShape.displayName().nonEmpty() ? propertyShape.displayName().value() : (propertyShape.range().displayName().nonEmpty() ? propertyShape.range().displayName().value() : null);
        this.description = propertyShape.description().nonEmpty() ? propertyShape.description().value() : propertyShape.range().description().value();
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel((AnyShape)propertyShape.range(), AMFParameterModel.getDefaultMediaType(propertyShape.range()), false, false);
        this.summary = this.displayName;
        this.parameter = null;
    }

    public AMFParameterModel(String name, APIParameterType parameterType, APIPrimitiveType amfPrimitiveTypeParser) {
        this.externalName = name;
        this.displayName = null;
        this.parameterType = parameterType;
        this.typeModel = new AMFTypeModel(amfPrimitiveTypeParser);
        this.parameter = null;
    }

    private static String buildDefaultValue(Parameter parameter) {
        StrField defaultValue = AMFParameterModel.getParameterShape(parameter).defaultValueStr();
        return defaultValue.nonEmpty() ? defaultValue.value() : "";
    }

    private static String getDefaultMediaType(Shape shape) {
        if (shape instanceof FileShape) {
            return "application/octet-stream";
        }
        if (shape instanceof NodeShape || shape instanceof ArrayShape || shape instanceof UnionShape) {
            return "application/json";
        }
        if (shape instanceof SchemaShape) {
            if (AMFParameterModel.isXmlSchemaShape(shape)) {
                return "application/xml";
            }
            return "application/json";
        }
        return "text/plain";
    }

    private static boolean isXmlSchemaShape(Shape shape) {
        if (!(shape instanceof SchemaShape)) {
            return false;
        }
        SchemaShape schemaShape = (SchemaShape)shape;
        return schemaShape.raw().nonEmpty() && XmlUtils.isXmlSchema(schemaShape.raw().value());
    }

    private static Shape getParameterShape(Parameter parameter) {
        Shape shape = parameter.schema();
        return shape != null ? shape : (Shape)parameter.payloads().stream().map(AbstractPayload::schema).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Graph graph() {
        return this.parameter.graph();
    }

    @Override
    public APILocation getLocation() {
        return APILocation.from(this.parameter.annotations());
    }
}

