/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.SchemaShape;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIJsonTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIXmlTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf.AMFTypeSchemaSupplier;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;

public class AMFTypeSchemaModel
extends APITypeSchemaModel {
    protected AMFTypeSchemaModel(Supplier<String> schemaSupplier, MediaType mediaType) {
        this.schemaSupplier = schemaSupplier;
        this.mediaType = mediaType;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static class AMFJsonTypeSchemaModel
    extends APIJsonTypeSchemaModel {
        public AMFJsonTypeSchemaModel(Supplier<String> schemaSupplier) {
            this.mediaType = MediaType.APPLICATION_JSON_TYPE;
            this.schemaSupplier = schemaSupplier;
        }
    }

    protected static class AMFXmlTypeSchemaModel
    extends APIXmlTypeSchemaModel {
        public AMFXmlTypeSchemaModel(Supplier<String> schemaSupplier) {
            this(schemaSupplier, null, null);
        }

        public AMFXmlTypeSchemaModel(Supplier<String> schemaSupplier, String elementName, String path) {
            this.mediaType = MediaType.APPLICATION_XML_TYPE;
            this.schemaSupplier = schemaSupplier;
            this.elementName = elementName;
            this.path = path;
        }
    }

    protected static class Builder {
        protected Builder() {
        }

        public APITypeSchemaModel build(AnyShape shape, MediaType mediaType) {
            if (shape instanceof SchemaShape && ((SchemaShape)shape).raw().nonEmpty()) {
                SchemaShape schemaShape = (SchemaShape)shape;
                Supplier<String> supplier = () -> schemaShape.raw().value();
                if (XmlUtils.isXmlSchema(schemaShape.raw().value())) {
                    String elementName = schemaShape.annotations().fragmentName().orElse(null);
                    String path = schemaShape.location().orElse(null);
                    return new AMFXmlTypeSchemaModel(supplier, elementName, path);
                }
                return new AMFJsonTypeSchemaModel(supplier);
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
                return new AMFJsonTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType));
            }
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
                return new AMFXmlTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType));
            }
            return new AMFTypeSchemaModel(new AMFTypeSchemaSupplier(shape, mediaType), mediaType);
        }
    }
}

