/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.amf;

import amf.core.client.common.render.JSONSchemaVersion;
import amf.core.client.common.render.JsonSchemaDraft7$;
import amf.core.client.platform.config.RenderOptions;
import amf.core.client.scala.model.domain.Shape;
import amf.shapes.client.platform.ShapesConfiguration;
import amf.shapes.client.platform.ShapesElementClient;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.xml.internal.transformer.TypeToXmlSchema;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;
import org.apache.ws.commons.schema.XmlSchema;

public class AMFTypeSchemaSupplier
implements Supplier<String> {
    private static final RenderOptions RENDER_OPTIONS = new RenderOptions().withDocumentation().withCompactedEmission().withSchemaVersion((JSONSchemaVersion)JsonSchemaDraft7$.MODULE$);
    private static final ShapesConfiguration JSON_EMITTER_CONFIGURATION = ShapesConfiguration.predefined().withRenderOptions(RENDER_OPTIONS);
    private static final ShapesElementClient JSON_EMITTER_CLIENT = JSON_EMITTER_CONFIGURATION.elementClient();
    private final AnyShape shape;
    private final MediaType mediaType;

    AMFTypeSchemaSupplier(AnyShape shape, MediaType mediaType) {
        this.shape = shape;
        this.mediaType = mediaType;
    }

    @Override
    public String get() {
        if (this.mediaType != null && this.mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return this.buildXmlTypeSchema(this.shape);
        }
        return JSON_EMITTER_CLIENT.buildJsonSchema(this.shape);
    }

    private String buildXmlTypeSchema(AnyShape anyShape) {
        XmlSchema xmlSchema = TypeToXmlSchema.transform((String)"root", (Shape)anyShape._internal());
        xmlSchema.setTargetNamespace("http://validationnamespace.raml.org");
        StringWriter schemaWriter = new StringWriter();
        xmlSchema.write((Writer)schemaWriter);
        return schemaWriter.toString();
    }
}

