/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.webapi.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class ParserUtils {
    private static final Pattern LOWER_UPPER_CASE_PATTERN = Pattern.compile("([a-z])([A-Z])");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<([a-zA-Z]*)(?:\\s[^>]*)*>(.*?)</(?:\\1)>");

    public static String splitCaps(String string, String split) {
        return LOWER_UPPER_CASE_PATTERN.matcher(string).replaceAll("$1" + split + "$2");
    }

    public static String removeHtmlTags(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return string;
        }
        Matcher matcher = HTML_TAG_PATTERN.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$2");
            matcher = HTML_TAG_PATTERN.matcher(string);
        }
        return string;
    }
}

