/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.modules.cryptography.api.jce.config.JceKeystoreType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JceKeystore {
    private KeyStore keystore;
    private LoadingCache<Pair<String, String>, Key> keyCache = Caffeine.newBuilder().build(userAndPassPair -> this.keystore.getKey((String)userAndPassPair.getFirst(), ((String)userAndPassPair.getSecond()).toCharArray()));
    private LoadingCache<Pair<String, String>, KeyStore.Entry> keyEntryCache = Caffeine.newBuilder().build(userAndPassPair -> this.keystore.getEntry((String)userAndPassPair.getFirst(), new KeyStore.PasswordProtection(((String)userAndPassPair.getSecond()).toCharArray())));

    public JceKeystore(String path, JceKeystoreType type, String password) {
        try {
            this.keystore = KeyStore.getInstance(type.name());
            InputStream resource = IOUtils.getResourceAsStream((String)path, this.getClass());
            if (resource == null) {
                throw new FileNotFoundException(String.format("Could not find JCE keystore '%s'", path));
            }
            this.keystore.load(resource, password.toCharArray());
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Key getPublicKey(String alias) {
        try {
            Certificate certificate = this.keystore.getCertificate(alias);
            if (certificate != null) {
                return certificate.getPublicKey();
            }
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Public key for alias '%s' not found", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        catch (KeyStoreException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining public key for alias '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.KEY);
        }
    }

    private Key getKey(String alias, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return (Key)this.keyCache.get((Object)new Pair((Object)alias, (Object)password));
    }

    private KeyStore.Entry getKeyEntry(String alias, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return (KeyStore.Entry)this.keyEntryCache.get((Object)new Pair((Object)alias, (Object)password));
    }

    public Key getPrivateKey(String alias, String password) {
        try {
            Key key = this.getKey(alias, password);
            if (key != null) {
                return key;
            }
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Private key for alias '%s' not found", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining private key for alias '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.KEY);
        }
        catch (UnrecoverableKeyException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Wrong password for key '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
        }
    }

    public KeyStore.Entry getEntry(String alias, String password) {
        try {
            KeyStore.Entry key = this.getKeyEntry(alias, password);
            if (key != null) {
                return key;
            }
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Key for alias '%s' not found", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Error obtaining Key for alias '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.KEY);
        }
        catch (UnrecoverableEntryException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Wrong password for key '%s'", alias));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
        }
    }

    public boolean keyExists(String alias) {
        try {
            return this.keystore.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)("Keystore error when searching for key: " + alias)), (ErrorTypeDefinition)CryptoErrors.KEY, (Throwable)e);
        }
    }

    public KeyStore getUnderlyingKeyStore() {
        return this.keystore;
    }
}

