/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.jce.impl;

import com.mulesoft.modules.cryptography.api.jce.config.JceSymmetricKeyInfo;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.jce.impl.JceKeyImpl;
import java.io.InputStream;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Mac;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class JceSymmetricKeyImpl
extends JceKeyImpl {
    private JceConfiguration config;
    private JceSymmetricKeyInfo keyInfo;

    public JceSymmetricKeyImpl(JceConfiguration config, JceSymmetricKeyInfo keyInfo) {
        this.config = config;
        this.keyInfo = keyInfo;
    }

    @Override
    public String sign(InputStream content, String algorithm) {
        byte[] inputBytes = IOUtils.toByteArray((InputStream)content);
        try {
            Key key = this.keyInfo.getSymmetricKey(this.config.getKeystore());
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
            byte[] hmacData = mac.doFinal(inputBytes);
            return new String(Base64.getEncoder().encode(hmacData));
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign data"), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    @Override
    public boolean validate(InputStream value, String expected, String algorithm) {
        try {
            String signature = this.sign(value, algorithm);
            return signature.equals(expected);
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not validate data"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }

    @Override
    protected Encrypter encrypter(String algorithm) {
        return new JCEEncrypter(algorithm, (EncryptionKeyFactory)((SymmetricKeyFactory)() -> this.keyInfo.getSymmetricKey(this.config.getKeystore())), this.config.getUseRandomIVs());
    }
}

