/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpSignatureAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpSigner {
    private PgpConfiguration config;

    public PgpSigner(PgpConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream sign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm) {
        try {
            if (keyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signing is only possible with asymmetric keys"), (ErrorTypeDefinition)CryptoErrors.KEY);
            }
            PGPPrivateKey pgpPrivateKey = keyInfo.getPrivateKey(this.config.getKeystore());
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                int keyAlgorithm = pgpPrivateKey.getPublicKeyPacket().getAlgorithm();
                JcaPGPContentSignerBuilder signerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, algorithm.getNumericId());
                signerBuilder.setProvider("BC");
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)signerBuilder);
                signatureGenerator.init(0, pgpPrivateKey);
                byte[] inputBytes = org.mule.runtime.core.api.util.IOUtils.toByteArray((InputStream)inputStream);
                signatureGenerator.update(inputBytes);
                BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)result);
                try {
                    signatureGenerator.generate().encode((OutputStream)bcpgOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)bcpgOutputStream);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result.toByteArray());
                return byteArrayInputStream;
            }
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign with PGP"), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    public boolean validate(InputStream inputStream, InputStream expectedSignature) {
        try {
            PGPSignatureList pgpSigList;
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)expectedSignature);
            JcaPGPObjectFactory pgpObjFactory = new JcaPGPObjectFactory(sigInputStream);
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), null);
                pgpSigList = (PGPSignatureList)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (PGPSignatureList)obj;
            }
            PGPSignature sig = pgpSigList.get(0);
            PGPPublicKey pubKey = this.config.getKeystore().getPublicKey(sig.getKeyID());
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
            byte[] inputBytes = org.mule.runtime.core.api.util.IOUtils.toByteArray((InputStream)inputStream);
            sig.update(inputBytes);
            sigInputStream.close();
            return sig.verify();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }
}

