/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.reference;

import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.XMLUtils;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.reference.SignatureContextProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetachedSignatureContextProvider
implements SignatureContextProvider {
    private XmlSignDigestAlgorithm digestAlgorithm;
    private String elementPath;
    private Document document;

    public DetachedSignatureContextProvider(XmlSignDigestAlgorithm digestAlgorithm, Document document, String referenceUri) {
        this.digestAlgorithm = digestAlgorithm;
        this.document = document;
        this.elementPath = referenceUri;
    }

    @Override
    public Reference getReference() {
        try {
            Element idElement = XMLUtils.validateXpathInDocument(this.document, this.elementPath);
            String idAttrName = XMLUtils.getIDAttributeName(idElement);
            XMLUtils.setAttributeAsIdCreatingIfNotFound(idElement, idAttrName);
            String uri = String.format("#%s", idElement.getAttribute(idAttrName));
            DigestMethod digestMethod = XmlKeyImpl.fac.newDigestMethod(this.digestAlgorithm.getAlgorithm(), null);
            return XmlKeyImpl.fac.newReference(uri, digestMethod);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Error getting reference of element to sign"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS, (Throwable)e);
        }
    }

    @Override
    public List<XMLObject> getReferencedObjects() {
        return null;
    }

    @Override
    public Node getSignatureParentNode() {
        return this.document.getDocumentElement();
    }
}

