/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.api;

/**
 * <p>Interface that all the custom assertions must implement</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public interface MunitAssertion {

  /**
   * <p>Method that asserts a mule event</p>
   *
   * @param expression <p>Expression to be asserted</p></p>
   * @param params     <p>Additional parameters to be used</p></p>
   * @throws AssertionError <p>Case the assertion fails</p>
   */
  void execute(TypedValue expression, Object params) throws AssertionError;
}
