/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.api.expression;

import java.util.List;

/**
 * Class that represents the result of a comparison
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class MatcherResult {

  private boolean matches;
  private Description description;
  private List<String> reasons;

  public boolean isMatches() {
    return matches;
  }

  public void setMatches(boolean matches) {
    this.matches = matches;
  }

  public void setDescription(Description description) {
    this.description = description;
  }

  public void setReasons(List<String> reasons) {
    this.reasons = reasons;
  }

  public Description getDescription() {
    return description;
  }

  public List<String> getReasons() {
    return reasons;
  }

  /**
   * Description of a failed comparison
   *
   * @author Mulesoft Inc.
   * @since 2.2.0
   */
  public static class Description {

    private String expected;
    private String actual;

    public String getExpected() {
      return expected;
    }

    public void setExpected(String expected) {
      this.expected = expected;
    }

    public String getActual() {
      return actual;
    }

    public void setActual(String actual) {
      this.actual = actual;
    }

    @Override
    public String toString() {
      return "Description{" +
          "expected='" + expected + '\'' +
          ", actual='" + actual + '\'' +
          '}';
    }
  }

  @Override
  public String toString() {
    return "MatcherResult{" +
        "matches=" + matches +
        ", description=" + description +
        ", reasons=" + reasons +
        '}';
  }
}
