/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.assertion.internal.matchers;


import static org.hamcrest.CoreMatchers.nullValue;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

/**
 * A TypedValueMatcher that uses a media type compare to another media type of a typed value
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MediaTypeMatcher extends TypedValueMatcher {

  private MediaType mediaType;

  public MediaTypeMatcher(MediaType mediaType) {
    this.mediaType = mediaType;
  }

  @Override
  public boolean doMatch(TypedValue typedValue) {
    if (mediaType == null) {
      return nullValue().matches(typedValue.getDataType().getMediaType());
    }
    return mediaType.matches(typedValue.getDataType().getMediaType());
  }

  @Override
  public void describeMismatch(Object item, Description description) {
    super.describeMismatch(getDescription(((TypedValue) item).getDataType().getMediaType()), description);
  }

  @Override
  public void describeTo(Description description) {
    if (mediaType == null) {
      nullValue().describeTo(description);
      return;
    }
    description.appendText(getDescription(mediaType));
  }

  private String getDescription(MediaType mediaType) {
    return mediaType.withoutParameters().toRfcString();
  }

  @Override
  public Matcher<Object> toPlainValueMatcher() {
    throw new IllegalStateException("Media Type Matcher cannot be compared to a value");
  }

}

