/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model;

import java.util.Objects;

/**
 * <p>
 * An abstract model that represents the Error of a Mule Event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.4
 */
public abstract class BaseEventError {

  public abstract String getTypeId();

  public abstract Object getCause();

  public abstract void setTypeId(String id);

  public abstract void setCause(Object cause);

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof BaseEventError)) {
      return false;

    } else if (object == this) {
      return true;
    }

    BaseEventError that = (BaseEventError) object;

    return Objects.equals(this.getTypeId(), that.getTypeId()) &&
        Objects.equals(this.getCause(), that.getCause());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTypeId(), getCause());
  }
}
