/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.report.xml;

import java.util.ArrayList;
import java.util.List;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;


/**
 * <p>
 * Model to represent the test suite in the xml report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@XStreamAlias(value = "testsuite")
public class TestSuite {

  @XStreamAsAttribute
  @XStreamAlias("xmlns:xsi")
  private final String xsi = "http://www.w3.org/2001/XMLSchema-instance";
  @XStreamAsAttribute
  @XStreamAlias("xsi:schemaLocation")
  private final String schemaLocation = "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd";

  @XStreamAsAttribute
  private String name;
  @XStreamAsAttribute
  private float time;
  @XStreamAsAttribute
  private int failures;
  @XStreamAsAttribute
  private int errors;
  @XStreamAsAttribute
  private int skipped;
  @XStreamAsAttribute
  private int tests;
  private List<Property> properties;
  @XStreamImplicit
  private List<TestCase> testcases = new ArrayList<TestCase>();

  public TestSuite(List<Property> properties, String name) {
    this.properties = properties;
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public float getTime() {
    return time;
  }

  public void setTime(float time) {
    this.time = time;
  }

  public int getFailures() {
    return failures;
  }

  public void setFailures(int failures) {
    this.failures = failures;
  }

  public int getErrors() {
    return errors;
  }

  public void setErrors(int errors) {
    this.errors = errors;
  }

  public int getSkipped() {
    return skipped;
  }

  public void setSkipped(int skipped) {
    this.skipped = skipped;
  }

  public int getTests() {
    return tests;
  }

  public void setTests(int tests) {
    this.tests = tests;
  }

  public List<TestCase> getTestcases() {
    return testcases;
  }

  public void setTestcases(List<TestCase> testcases) {
    this.testcases = testcases;
  }

  public void add(TestCase testCase) {
    this.testcases.add(testCase);
  }
}
