/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.container;

import java.util.List;

import org.apache.commons.lang3.ArrayUtils;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;

/**
 * <p>
 * Creates a {@link BundleDescriptor} based on the {@link ServerPluginConfiguration}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class BundleDescriptorFactory {

  public static BundleDescriptor[] buildServerPluginDescriptors(List<ServerPluginConfiguration> plugins) {
    if (plugins == null) {
      return ArrayUtils.toArray();
    }
    return plugins.stream().map(BundleDescriptorFactory::toBundleDescriptor).toArray(BundleDescriptor[]::new);
  }

  private static BundleDescriptor toBundleDescriptor(ServerPluginConfiguration config) {
    BundleDescriptor.Builder builder = new BundleDescriptor.Builder()
        .setGroupId(config.getGroupId())
        .setArtifactId(config.getArtifactId())
        .setVersion(config.getVersion());
    if (config.getBaseVersion() != null) {
      builder.setBaseVersion(config.getBaseVersion());
    }
    if (config.getType() != null) {
      builder.setType(config.getType());
    }
    builder.setClassifier(config.getClassifier());
    return builder.build();
  }

}
