/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.printer.model;

import org.mule.munit.remote.coverage.model.MuleFlow;
import org.mule.munit.remote.coverage.model.MuleFlowLine;
import org.mule.munit.remote.coverage.model.MuleLocation;

import java.util.List;
import java.util.Vector;

/**
 * <p>
 * Model that represents a Mule Flow.
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MuleFlowModel {

  private String name;
  private String type;
  private double coverage;
  private int messageProcessorCount;
  private int coveredProcessorCount;
  private List<MuleFlowLine> lines;

  public MuleFlowModel(MuleFlow flow) {
    this.coverage = flow.getCoverage();
    this.name = flow.getName();
    this.type = flow.getType();
    this.messageProcessorCount = flow.getLocations().size();
    this.coveredProcessorCount = flow.getCoveredLocations().size();
    this.lines = getFlowLines(flow);
  }

  private List<MuleFlowLine> getFlowLines(MuleFlow flow) {

    List<Integer> coveredLines = new Vector<>();

    for (MuleLocation coveredLocation : flow.getCoveredLocations()) {
      coveredLines.add(coveredLocation.getLineNumber());
    }

    List<MuleFlowLine> flowLines = new Vector<>();

    for (MuleLocation location : flow.getLocations()) {
      boolean isLineCovered = coveredLines.contains(location.getLineNumber());

      MuleFlowLine line = new MuleFlowLine(location.getLineNumber(), isLineCovered);
      flowLines.add(line);
    }

    return flowLines;
  }

  public double getCoverage() {
    return coverage;
  }

  public void setCoverage(double coverage) {
    this.coverage = coverage;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public int getProcessorCount() {
    return messageProcessorCount;
  }

  public void setProcessorCount(int processorCount) {
    this.messageProcessorCount = processorCount;
  }

  public int getMessageProcessorCount() {
    return coveredProcessorCount;
  }

  public void setCoveredProcessorCount(int coveredProcessorCount) {
    this.coveredProcessorCount = coveredProcessorCount;
  }

  public List<MuleFlowLine> getLines() {
    return lines;
  }

  public void setLines(List<MuleFlowLine> lines) {
    this.lines = lines;
  }
}
