/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.runtime.utils;

import static java.util.Optional.ofNullable;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * This object matches the mule-artifact.json element within a application. The describer holds information that has being picked
 * up from the JSON file (and the pom.xml when implemented).
 *
 * @author Mulesoft Inc.
 *
 * @since 1.0
 */
public class MuleApplicationModel extends MuleDeployableModel {

  private String domain;

  private MuleApplicationModel(String name, String minMuleVersion, Product product,
                               MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor,
                               MuleArtifactLoaderDescriptor bundleDescriptor, Set<String> configs,
                               Optional<String> domain, Optional<Boolean> redeploymentEnabled,
                               List<String> secureProperties, String logConfigFile) {
    super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptor, configs, redeploymentEnabled,
          secureProperties, logConfigFile);
    this.domain = domain.orElse(null);
  }

  public MuleApplicationModel() {
    super();
  };

  /**
   * @return the domain associated with this application
   */
  public Optional<String> getDomain() {
    return ofNullable(domain);
  }

  /**
   * A builder to create instances of {@link MuleApplicationModel}.
   *
   * @since 1.0
   */
  public static class MuleApplicationModelBuilder
      extends MuleDeployableModelBuilder<MuleApplicationModelBuilder, MuleApplicationModel> {

    private String domain;

    @Override
    protected MuleApplicationModelBuilder getThis() {
      return this;
    }

    /**
     * @param domain the domain associated with this application
     * @return the same builder instance.
     */
    public MuleApplicationModelBuilder setDomain(String domain) {
      this.domain = domain;
      return this;
    }

    @Override
    protected MuleApplicationModel doCreateModel(Set<String> configs, Boolean redeploymentEnabled,
                                                 List<String> secureProperties, String logConfigFile) {
      return new MuleApplicationModel(getName(), getMinMuleVersion(), getRequiredProduct(), getClassLoaderModelDescriptorLoader(),
                                      getBundleDescriptorLoader(), configs, ofNullable(domain), ofNullable(redeploymentEnabled),
                                      secureProperties, logConfigFile);

    }
  }
}
