/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.remote.runtime.utils;

import java.util.Collections;
import java.util.Map;

/**
 * Generic descriptor that will be used to describe parametrization to construct {@link ExtensionModel}, {@link ClassLoader} and
 * any other descriptor that may arise in a future of {@link MulePluginModel}.
 * <p/>
 * Each {@link MuleArtifactLoaderDescriptor} will have an ID that will be used to discover any loader that's responsible of
 * working with the current set of attributes. It's up to each loader to validate the types, size and all that matters around the
 * attributes.
 * @author Mulesoft Inc.
 * @since 1.0
 */
public final class MuleArtifactLoaderDescriptor {

  private String id;
  private Map<String, Object> attributes;

  public MuleArtifactLoaderDescriptor(String id, Map<String, Object> attributes) {
    this.id = id;
    this.attributes = Collections.unmodifiableMap(attributes);
  }

  public MuleArtifactLoaderDescriptor() {}

  public String getId() {
    return this.id;
  }

  public Map<String, Object> getAttributes() {
    return this.attributes;
  }
}
