/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;

import java.util.Collections;
import java.util.Set;

/**
 * A test component interface MUnit is able to run
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public interface TestComponent extends Component {


  String getName();

  String getDescription();

  Event run(Event event) throws Throwable;

  default Set<String> getTags() {
    return Collections.emptySet();
  }

  default boolean isIgnored() {
    return false;
  }

  default void setUp() {}

  default void tearDown() {}

}
