/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component;

import org.mule.runtime.api.component.ComponentIdentifier;

/**
 * Test component information provider. Provides information for the test to be initialized and looked up in the registry
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public interface TestComponentInfoProvider {


  /**
   * Component identifier of the test in order to be found
   * 
   * @return component identifier of the test
   */
  ComponentIdentifier getComponentIdentifier();

}
