/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component.rules;

import java.io.File;
import java.io.IOException;
import java.util.Optional;

import javax.inject.Inject;

import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Provides logic to manage MUnit testing rules
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class TemporaryDirectoryRule implements TestRule, Disposable {

  @Inject
  protected ConfigurationProperties configurationProperties;

  private static final Logger logger = LoggerFactory.getLogger(TemporaryDirectoryRule.class);
  protected static final String TEMP_DIRECTORY_PROPERTY = "munit.temporary.directory";

  @Override
  public void reset() {
    getTemporaryDirectory().ifPresent(tempDir -> {
      try {
        FileUtils.cleanDirectory(new File(tempDir));
      } catch (IOException e) {
        logger.error("An error occurred when cleaning temporary folder {}", tempDir, e);
      }
    });
  }

  @Override
  public void dispose() {
    getTemporaryDirectory().ifPresent(tempDir -> {
      try {
        FileUtils.deleteDirectory(new File(tempDir));
      } catch (IOException e) {
        logger.error("An error occurred when deleting temporary folder {}", tempDir, e);
      }
    });
  }

  private Optional<String> getTemporaryDirectory() {
    return configurationProperties.resolveStringProperty(TEMP_DIRECTORY_PROPERTY);
  }
}
