/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.component.rules;

import java.util.Collections;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import static org.mule.munit.common.util.Preconditions.checkArgument;

/**
 * Contains information about the test to be run
 * 
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class TestDescription {

  private final String name;
  private final String description;
  private final boolean ignored;
  private final Set<String> tags;

  private TestDescription(String name, String description, boolean ignored, Set<String> tags) {
    this.name = name;
    this.description = description;
    this.ignored = ignored;
    this.tags = tags;
  }

  public String getName() {
    return name;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public String getDescription() {
    return description;
  }

  public Set<String> getTags() {
    return tags;
  }

  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder for a {@link TestDescription}
   * 
   * @author Mulesoft Inc.
   * @since 2.2.0
   */
  public static class Builder {

    private String name;
    private String description = StringUtils.EMPTY;
    private boolean ignored;
    private Set<String> tags = Collections.emptySet();

    private Builder() {

    }

    public Builder name(String name) {
      checkArgument(name != null, "Name cannot be null");
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      checkArgument(description != null, "Description cannot be null");
      this.description = description;
      return this;
    }

    public Builder ignored(boolean ignored) {
      this.ignored = ignored;
      return this;
    }

    public Builder tags(Set<String> tags) {
      checkArgument(tags != null, "Tags cannot be null");
      this.tags = tags;
      return this;
    }

    public TestDescription build() {
      return new TestDescription(name, description, ignored, tags);
    }
  }
}
