/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.config;

import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.runtime.api.component.ComponentIdentifier;

/**
 * {@link TestComponentInfoProvider} for the dbserver:config
 *
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class DbServerTestComponentInfoProvider implements TestComponentInfoProvider {

  private static final ComponentIdentifier DB_SERVER_IDENTIFIER =
      ComponentIdentifier.builder().namespace("dbserver").name("config").build();

  @Override
  public ComponentIdentifier getComponentIdentifier() {
    return DB_SERVER_IDENTIFIER;
  }
}
