/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.functions;

import static java.util.Collections.singletonList;
import static org.mule.runtime.api.metadata.DataType.STRING;

import java.util.List;
import java.util.Optional;

import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

/**
 * {@link ExpressionFunction} that checks if the provided os name is equal to the current one
 *
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class OsEqualToFunction implements ExpressionFunction {

  private final ConfigurationProperties configurationProperties;

  public OsEqualToFunction(ConfigurationProperties configurationProperties) {
    this.configurationProperties = configurationProperties;
  }

  @Override
  public Object call(Object[] parameters, BindingContext bindingContext) {
    String osName = (String) parameters[0];
    return getCurrentOsName().equals(osName);
  }

  @Override
  public Optional<DataType> returnType() {
    return Optional.of(DataType.BOOLEAN);
  }

  @Override
  public List<FunctionParameter> parameters() {
    return singletonList(new FunctionParameter("osName", STRING));
  }

  private String getCurrentOsName() {
    return configurationProperties.resolveStringProperty("os.name")
        .orElseThrow(() -> new IllegalStateException("Unable to check operating system: 'os.name' property is not defined"));
  }
}
