/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;

import static org.mule.metadata.java.api.JavaTypeLoader.JAVA;
import static org.mule.sdk.api.stereotype.MuleStereotypes.FLOW;
import static org.mule.sdk.api.stereotype.MuleStereotypes.SUB_FLOW;

/**
 * <p>
 * Model that represents the list of flows to be excluded
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@Deprecated
public class EnableFlowSources {

  protected List<FlowRef> flows = new ArrayList<>();

  public List<FlowRef> getFlows() {
    return flows;
  }

  public void setFlows(List<FlowRef> flows) {
    this.flows = flows;
  }

  /**
   * Inner object holding reference to a flow
   */
  @Alias("enableFlowSource")
  public static class FlowRef {

    /**
     * Definition of the attribute properties metadata.
     */
    public static class DefaultTypeResolver extends InputStaticTypeResolver {

      @Override
      public MetadataType getStaticMetadata() {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create(JAVA).objectType()
            .with(new TypeAliasAnnotation("enableFlowSource"))
            .with(new TypeIdAnnotation("org.mule.munit.runner.processors.EnableFlowSources.FlowRef"))
            .with(new TypeDslAnnotation(true, false, null, null));

        objectTypeBuilder.addField().key("value")
            .with(new ExpressionSupportAnnotation(ExpressionSupport.SUPPORTED))
            .with(new StereotypeTypeAnnotation(Arrays.asList(FLOW, SUB_FLOW)))
            .with(new ClassInformationAnnotation(Component.class))
            .value().stringType();

        return objectTypeBuilder.build();
      }
    }

    @FlowReference
    @Alias("value")
    @Parameter
    private Component flow;

    public Component getFlow() {
      return flow;
    }

    public void setFlow(Component flow) {
      this.flow = flow;
    }
  }
}
