/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.runner.SuiteRunner;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.SuiteResult;
import org.mule.runtime.api.event.Event;

public class SuiteRunnerTest {
    private static final String AFTER_SUITE_NAME = "AfterSuiteName";
    private static final String AFTER_SUITE_DESCRIPTION = "After Suite Description";
    private static final String BEFORE_SUITE_NAME = "BeforeSuiteName";
    private static final String BEFORE_SUITE_DESCRIPTION = "Before Suite Description";
    private static final String SUITE_PATH = "test/example_suite.xml";
    private static final String SUITE_PARAMETERIZATION = "param1";
    private List<AfterSuite> afterSuiteFlows;
    private List<BeforeSuite> beforeSuiteFlows;
    private TestFlow testFlowMock;
    private AfterSuite afterSuiteMock;
    private BeforeSuite beforeSuiteMock;
    private SuiteRunEventListener suiteRunEventListenerMock;
    private SuiteRunner runner;
    private Suite suiteMock;

    @Before
    public void setUp() {
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        this.afterSuiteMock = (AfterSuite)Mockito.mock(AfterSuite.class);
        this.beforeSuiteMock = (BeforeSuite)Mockito.mock(BeforeSuite.class);
        this.suiteMock = (Suite)Mockito.mock(Suite.class);
        this.afterSuiteFlows = Arrays.asList(this.afterSuiteMock);
        this.beforeSuiteFlows = Arrays.asList(this.beforeSuiteMock);
        this.suiteRunEventListenerMock = (SuiteRunEventListener)Mockito.mock(SuiteRunEventListener.class);
        this.runner = new SuiteRunner(this.suiteMock, this.suiteRunEventListenerMock);
    }

    @Test
    public void verifySuiteNotRunIfNoTests() throws Exception {
        this.setBehavior();
        Mockito.when((Object)this.suiteMock.getNumberOfTests()).thenReturn((Object)0);
        this.runner.run();
        ((Suite)Mockito.verify((Object)this.suiteMock, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void verifySuiteNotRunIfAllTestsIgnored() throws Exception {
        this.setBehavior();
        Mockito.when((Object)this.suiteMock.allTestsIgnored()).thenReturn((Object)true);
        this.runner.run();
        ((Suite)Mockito.verify((Object)this.suiteMock, (VerificationMode)Mockito.never())).run();
    }

    @Test(expected=RuntimeException.class)
    public void verifyBeforeSuiteError() throws Exception {
        this.setBehavior();
        CompletableFuture completableFutureMock = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when((Object)((Event)completableFutureMock.get())).thenThrow(new Throwable[]{new Exception()});
        Mockito.when((Object)this.beforeSuiteMock.execute((Event)Mockito.any(Event.class))).thenReturn((Object)completableFutureMock);
        Mockito.when((Object)this.suiteMock.run()).thenReturn(null);
        this.runner.run();
    }

    @Test
    public void verifySuiteRunningWithTests() throws Exception {
        this.setBehavior();
        int numberOfTests = 1;
        SuiteResult suiteResultMock = (SuiteResult)Mockito.mock(SuiteResult.class);
        Mockito.when((Object)this.suiteMock.getNumberOfTests()).thenReturn((Object)numberOfTests);
        Mockito.when((Object)this.suiteMock.allTestsIgnored()).thenReturn((Object)false);
        Mockito.when((Object)this.suiteMock.run()).thenReturn((Object)suiteResultMock);
        this.runner.run();
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifySuiteStart(SUITE_PATH, SUITE_PARAMETERIZATION, numberOfTests);
        ((SuiteRunEventListener)Mockito.verify((Object)this.suiteRunEventListenerMock)).notifySuiteEnd((String)Mockito.eq((Object)SUITE_PATH), (String)Mockito.eq((Object)SUITE_PARAMETERIZATION), Mockito.anyLong());
    }

    private void setBehavior() {
        Mockito.when((Object)this.suiteMock.getPath()).thenReturn((Object)SUITE_PATH);
        Mockito.when((Object)this.suiteMock.getParameterization()).thenReturn((Object)SUITE_PARAMETERIZATION);
        Mockito.when((Object)this.afterSuiteMock.getDescription()).thenReturn((Object)AFTER_SUITE_DESCRIPTION);
        Mockito.when((Object)this.afterSuiteMock.getName()).thenReturn((Object)AFTER_SUITE_NAME);
        Mockito.when((Object)this.beforeSuiteMock.getDescription()).thenReturn((Object)BEFORE_SUITE_DESCRIPTION);
        Mockito.when((Object)this.beforeSuiteMock.getName()).thenReturn((Object)BEFORE_SUITE_NAME);
    }
}

