/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.factory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.munit.runner.component.factory.TestProcessorChainFactory;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;

public class TestProcessorChainFactoryTest {
    private TestProcessorChainFactory testProcessorChainFactory;
    private TestFlow testFlowMock;
    private PrivilegedMuleContext muleContextMock;

    @Before
    public void setUp() {
        ConfigurationComponentLocator componentLocatorMock = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
        Injector injectorMock = (Injector)Mockito.mock(Injector.class);
        this.muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        this.testProcessorChainFactory = new TestProcessorChainFactory();
        this.testProcessorChainFactory.muleContext = this.muleContextMock;
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        Mockito.when((Object)this.muleContextMock.getConfigurationComponentLocator()).thenReturn((Object)componentLocatorMock);
        Mockito.when((Object)this.muleContextMock.getInjector()).thenReturn((Object)injectorMock);
        Mockito.when((Object)componentLocatorMock.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.of(this.testFlowMock));
    }

    @Test(expected=IllegalArgumentException.class)
    public void chainHasObjectsThatAreNotProcessors() throws Exception {
        this.testProcessorChainFactory.setMessageProcessors(Collections.singletonList("NotAProcessor"));
        this.testProcessorChainFactory.doGetObject();
    }

    @Test
    public void processorsInChain() throws Exception {
        Processor processorMock = (Processor)Mockito.mock(Processor.class);
        List<Processor> processors = Collections.singletonList(processorMock);
        this.testProcessorChainFactory.setMessageProcessors(processors);
        MessageProcessorChain processorChain = this.testProcessorChainFactory.doGetObject();
        MatcherAssert.assertThat((Object)processorChain.getMessageProcessors(), (Matcher)Matchers.equalTo(processors));
    }
}

