/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.rules;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.munit.common.util.FileUtils;
import org.mule.munit.runner.component.rules.TemporaryDirectoryRule;
import org.mule.runtime.api.component.ConfigurationProperties;

public class TemporaryDirectoryRuleTest {
    private TemporaryDirectoryRule temporaryDirectoryRule;
    private File tempDir;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        this.tempDir = this.temporaryFolder.getRoot();
        ConfigurationProperties configurationPropertiesMock = (ConfigurationProperties)Mockito.mock(ConfigurationProperties.class);
        Mockito.when((Object)configurationPropertiesMock.resolveStringProperty("munit.temporary.directory")).thenReturn(Optional.of(this.tempDir.getAbsolutePath()));
        this.temporaryDirectoryRule = new TemporaryDirectoryRule();
        this.temporaryDirectoryRule.configurationProperties = configurationPropertiesMock;
    }

    @Test
    public void cleanTemporaryDirectory() throws IOException {
        this.temporaryFolder.newFile("example.txt");
        this.temporaryDirectoryRule.reset();
        Assert.assertThat((Object)FileUtils.listFiles((File)this.tempDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE), (Matcher)Matchers.empty());
    }

    @Test
    public void disposeDeletesTemporaryDirectory() throws IOException {
        this.temporaryFolder.newFile("example.txt");
        this.temporaryDirectoryRule.dispose();
        Assert.assertThat((Object)this.tempDir.exists(), (Matcher)Matchers.is((Object)false));
    }
}

