/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.functions;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.runner.functions.OsEqualToFunction;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

public class OsEqualToFunctionTest {
    private ConfigurationProperties configurationPropertiesMock;
    private OsEqualToFunction osEqualToFunction;

    @Before
    public void setUp() {
        this.configurationPropertiesMock = (ConfigurationProperties)Mockito.mock(ConfigurationProperties.class);
        this.osEqualToFunction = new OsEqualToFunction(this.configurationPropertiesMock);
    }

    @Test
    public void parametersAndReturnType() {
        MatcherAssert.assertThat((Object)this.osEqualToFunction.parameters(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((FunctionParameter)this.osEqualToFunction.parameters().get(0)).getName(), (Matcher)IsEqual.equalTo((Object)"osName"));
        MatcherAssert.assertThat((Object)((FunctionParameter)this.osEqualToFunction.parameters().get(0)).getType(), (Matcher)IsEqual.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)this.osEqualToFunction.returnType().isPresent(), (Matcher)IsEqual.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((DataType)this.osEqualToFunction.returnType().get()), (Matcher)IsEqual.equalTo((Object)DataType.BOOLEAN));
    }

    @Test
    public void osNamePresentAndEqual() {
        String osName = "Windows";
        Mockito.when((Object)this.configurationPropertiesMock.resolveStringProperty("os.name")).thenReturn(Optional.of(osName));
        Object result = this.osEqualToFunction.call(Collections.singletonList(osName).toArray(), BindingContext.builder().build());
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void osNamePresentAndDifferent() {
        Mockito.when((Object)this.configurationPropertiesMock.resolveStringProperty("os.name")).thenReturn(Optional.of("Linux"));
        Object result = this.osEqualToFunction.call(Collections.singletonList("Windows").toArray(), BindingContext.builder().build());
        MatcherAssert.assertThat((Object)result, (Matcher)IsEqual.equalTo((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void osNameAbsent() {
        Mockito.when((Object)this.configurationPropertiesMock.resolveStringProperty("os.name")).thenReturn(Optional.empty());
        this.osEqualToFunction.call(Collections.singletonList("Windows").toArray(), BindingContext.builder().build());
    }
}

