/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.munit.runner.model.builders.TestRunFilter;

public class TestRunFilterTest {
    private TestFlow testFlowMock;
    private TestRunFilter testRunFilter;

    @Before
    public void setUp() {
        this.testFlowMock = (TestFlow)Mockito.mock(TestFlow.class);
        this.testRunFilter = new TestRunFilter();
    }

    @Test
    public void munitTestNameMatchesShouldNotIgnore() {
        ArrayList<RunConfiguration.Test> list = new ArrayList<RunConfiguration.Test>();
        RunConfiguration.Test pair = RunConfiguration.Test.of((String)"suite_name", (String)"test_name");
        list.add(pair);
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", null, list, null, "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void munitTestNameDoesNotMatchShouldIgnore() {
        ArrayList<RunConfiguration.Test> list = new ArrayList<RunConfiguration.Test>();
        RunConfiguration.Test pair = RunConfiguration.Test.of((String)"not_matching_test_name", (String)"suite_name");
        list.add(pair);
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", null, list, null, "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)false));
    }

    @Test
    public void munitTestNameDoesNotMatchShouldIgnoreWithoutTags() {
        ArrayList<RunConfiguration.Test> list = new ArrayList<RunConfiguration.Test>();
        RunConfiguration.Test pair = RunConfiguration.Test.of((String)"not_matching_test_name", (String)"suite_name");
        list.add(pair);
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", list, "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)false));
    }

    @Test
    public void munitTestDoesNotMatchTagsShouldIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.singleton("oneTag"), Collections.emptyList(), Collections.singleton("otherTag"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)false));
    }

    @Test
    public void munitTestMatchesSameTagShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.singleton("oneTag"), Collections.emptyList(), Collections.singleton("oneTag"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void munitTestMatchesSameTrimmedTagShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.singleton("oneTag"), Collections.emptyList(), Collections.singleton("oneTag"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneOfTheTagsShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.singleton("oneTag"), Collections.emptyList(), new HashSet<String>(Arrays.asList("oneTag", "otherTag")), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneTagButHasOthersShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", new HashSet<String>(Arrays.asList("oneTag", "otherTag")), Collections.emptyList(), Collections.singleton("oneTag"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesOneCaseInsensitiveShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.singleton("oneTag"), Collections.emptyList(), Collections.singleton("ONETAG"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testMatchesEmptyTagListShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", new HashSet<String>(Arrays.asList("oneTag", "otherTag")), Collections.emptyList(), Collections.emptySet(), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWithEmptyListMatchesNoTagTokenShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.emptySet(), Collections.emptyList(), Collections.singleton("NO_TAG"), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBuildMunitTestsWithEmptyListMatchesTrimmedNoTagTokenShouldNotIgnore() {
        Boolean shouldRun = this.testRunFilter.shouldRunTest("test_name", Collections.emptySet(), Collections.emptyList(), Collections.singleton(" NO_TAG "), "suite_name");
        MatcherAssert.assertThat((Object)shouldRun, (Matcher)Is.is((Object)true));
    }
}

