/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataHandler;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.common.api.event.EventBuilder;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.NullObject;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.api.model.UntypedEventError;
import org.mule.munit.common.api.model.Variable;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.runner.processors.SetEventProcessor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public class SetEventProcessorTest {
    private static final String PAYLOAD = "r1";
    private static final String PAYLOAD_EXP = "#['exp']";
    private static final String VARIABLE_VALUE = "invocationValue";
    private static final String VARIABLE_KEY = "variableKey";
    private static final String VARIABLE_KEY_EXP = "#['variableKey']";
    private static final String ERROR_TYPE_ID = "my:error_type";
    private static final Exception ERROR_CAUSE_MOCK = (Exception)Mockito.mock(Exception.class);
    private static final String INVALID_MEL_EXPRESSION = "#['LALERO'";
    private static final String NON_STRING_MEL_EXPRESSION = "#[1]";
    private static final String NULL_MEL_EXPRESSION = "#[null]";
    private static final String TEST_ENCODING = StandardCharsets.US_ASCII.name();
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final String DEFAULT_MEDIA_TYPE = "*/*";
    private static final String ENCODING = StandardCharsets.US_ASCII.name();
    private static final String MEDIA_TYPE = "application/json";
    private static final Object ATTRIBUTES_MOCK = "EXAMPLE_ATTRIBUTES";
    private SetEventProcessor processor;
    private PrivilegedMuleContext muleContextMock;
    private ExtendedExpressionManager expressionManagerMock;
    private EventContext eventContextMock;
    private ErrorTypeLocator errorTypeLocatorMock;

    @Before
    public void setUp() throws InitialisationException {
        this.muleContextMock = (PrivilegedMuleContext)Mockito.mock(PrivilegedMuleContext.class);
        this.eventContextMock = (EventContext)Mockito.mock(BaseEventContext.class);
        this.expressionManagerMock = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        this.errorTypeLocatorMock = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        Mockito.when((Object)this.muleContextMock.getErrorTypeLocator()).thenReturn((Object)this.errorTypeLocatorMock);
        Mockito.when((Object)ERROR_CAUSE_MOCK.getMessage()).thenReturn((Object)"");
        this.processor = new SetEventProcessor();
        this.processor.setMuleContext(this.muleContextMock);
        this.processor.setExtendedExpressionManager(this.expressionManagerMock);
        this.processor.initialise();
    }

    @Test
    public void noExpressions() throws MuleException, IOException {
        this.processor.setVariables(this.variables(VARIABLE_KEY, VARIABLE_VALUE, MEDIA_TYPE, ENCODING));
        this.processor.setPayload(this.payload(PAYLOAD, MEDIA_TYPE, ENCODING));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)this.eventBuilder().build());
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, ENCODING);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)((InternalMessage)message).getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
        this.assertDataType(message.getPayload().getDataType(), MEDIA_TYPE, ENCODING);
        MatcherAssert.assertThat((String)"Attributes is not as expected", (Object)message.getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withExpressions() throws MuleException, IOException {
        this.mockEvaluateIfExpression(VARIABLE_KEY_EXP, VARIABLE_KEY);
        this.processor.setVariables(this.variables(VARIABLE_KEY_EXP, VARIABLE_VALUE, MEDIA_TYPE, ENCODING));
        this.processor.setPayload(this.payload(PAYLOAD, MEDIA_TYPE, ENCODING));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)this.eventBuilder().build());
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, ENCODING);
        Message message = event.getMessage();
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)message.getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
        this.assertDataType(message.getPayload().getDataType(), MEDIA_TYPE, ENCODING);
        MatcherAssert.assertThat((String)"Attributes is not as expected", (Object)message.getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
        Stream<String> expressionsKeys = Stream.of(VARIABLE_KEY_EXP);
        expressionsKeys.forEach(e -> this.verifyEvaluateIfExpression((String)e));
    }

    @Test
    public void withPayload() {
        this.processor.setPayload(this.payload(PAYLOAD));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
    }

    @Test
    public void withPayloadFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withPayload((Object)PAYLOAD).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)PAYLOAD));
    }

    @Test
    public void withNullPayloadFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withPayload((Object)PAYLOAD).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void withMediaType() {
        this.processor.setPayload(this.payload(MEDIA_TYPE, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withMediaTypeFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withNullMediaTypeFromEventItShouldDefault() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withEmptyMediaTypeFromEventItShouldDefault() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload("", null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.JSON_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withDifferentMediaTypeFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(DataType.JSON_STRING.getMediaType()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload("text/xml", null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getPrimaryType(), (Matcher)Is.is((Object)DataType.XML_STRING.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)mediaType.getSubType(), (Matcher)Is.is((Object)DataType.XML_STRING.getMediaType().getSubType()));
    }

    @Test
    public void withEncoding() {
        this.processor.setPayload(this.payload(null, TEST_ENCODING));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)TEST_ENCODING));
    }

    @Test
    public void withEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName(TEST_ENCODING));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)TEST_ENCODING));
    }

    @Test
    public void withNullEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName(TEST_ENCODING));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, null, null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)TEST_ENCODING));
    }

    @Test
    public void withDifferentEncodingFromEvent() {
        MediaType originalMediaType = DataType.JSON_STRING.getMediaType();
        originalMediaType = originalMediaType.withCharset(Charset.forName(TEST_ENCODING));
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withMediaType(originalMediaType).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(null, DEFAULT_ENCODING));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MediaType mediaType = event.getMessage().getPayload().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)DEFAULT_ENCODING));
    }

    @Test
    public void withAttributes() {
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withTypedAttributes() {
        String primaryType = "application";
        String subType = "java";
        String originalMediaType = primaryType + "/" + subType;
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK, originalMediaType, TEST_ENCODING));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MediaType mediaType = event.getMessage().getAttributes().getDataType().getMediaType();
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
        MatcherAssert.assertThat((String)"Encoding is not as expected", (Object)((Charset)mediaType.getCharset().get()).toString(), (Matcher)Is.is((Object)TEST_ENCODING));
        MatcherAssert.assertThat((String)"Media type is not as expected", (Object)(mediaType.getPrimaryType() + "/" + mediaType.getSubType()), (Matcher)Is.is((Object)originalMediaType));
    }

    @Test
    public void withAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes(ATTRIBUTES_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withNullAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes(ATTRIBUTES_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setAttributes(this.attributes(null));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withDifferentAttributesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withAttributes((Object)new NullObject()).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setAttributes(this.attributes(ATTRIBUTES_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Payload is not as expected", (Object)event.getMessage().getAttributes().getValue(), (Matcher)Is.is((Object)ATTRIBUTES_MOCK));
    }

    @Test
    public void withVariables() {
        this.processor.setVariables(this.variables(VARIABLE_KEY, VARIABLE_VALUE, MEDIA_TYPE, ENCODING));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, TEST_ENCODING);
    }

    @Test
    public void withVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, TEST_ENCODING).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", (Object)((TypedValue)event.getVariables().get(VARIABLE_KEY)).getValue(), (Matcher)Is.is((Object)VARIABLE_VALUE));
        this.assertDataType(((TypedValue)event.getVariables().get(VARIABLE_KEY)).getDataType(), MEDIA_TYPE, TEST_ENCODING);
    }

    @Test
    public void withEmptyVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, TEST_ENCODING).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setVariables(Collections.emptyList());
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", event.getVariables().keySet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test(expected=NullPointerException.class)
    public void withNullVariablesFromEvent() {
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().addVariable(VARIABLE_KEY, (Object)VARIABLE_VALUE, MEDIA_TYPE, TEST_ENCODING).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setVariables(null);
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Property is not as expected", event.getVariables().keySet(), (Matcher)Is.is(Collections.emptySet()));
    }

    @Test
    public void withError() {
        ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.errorTypeLocatorMock.lookupComponentErrorType((ComponentIdentifier)ArgumentMatchers.any(ComponentIdentifier.class), (Throwable)ArgumentMatchers.any(Throwable.class))).thenReturn((Object)errorTypeMock);
        this.processor.setError(this.error(ERROR_TYPE_ID, ERROR_CAUSE_MOCK));
        CoreEvent event = this.processor.doProcess((CoreEvent)((InternalEvent)this.eventBuilder().build()));
        MatcherAssert.assertThat((String)"Error is not as expected", (Object)((Error)event.getError().get()).getErrorType(), (Matcher)Is.is((Object)errorTypeMock));
    }

    @Test
    public void withErrorFromEvent() {
        ErrorType errorTypeMock = (ErrorType)Mockito.mock(ErrorType.class);
        InternalEvent originalEvent = (InternalEvent)this.eventBuilder().withError(errorTypeMock, (Throwable)ERROR_CAUSE_MOCK).build();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        CoreEvent event = this.processor.doProcess((CoreEvent)originalEvent);
        MatcherAssert.assertThat((String)"Error is not as expected", (Object)((Error)event.getError().get()).getErrorType(), (Matcher)Is.is((Object)errorTypeMock));
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaType() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncoding() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringErrorTypeId() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setError(this.error(NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Ignore
    @Test(expected=MunitError.class)
    public void withNonThrowableErrorCause() throws MuleException {
        String errorTypeId = "errorType";
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringKeyInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringMediaTypeInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, NON_STRING_MEL_EXPRESSION, null));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNonStringEncodingInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, null, NON_STRING_MEL_EXPRESSION));
        this.processNonStringExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullEvaluatedMediaTypeWhenCloningEvent() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(true));
        this.processor.setPayload(this.payload(NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullEvaluatedMediaTypeWhenNotCloningEvent() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withNullMediaTypeInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, NULL_MEL_EXPRESSION, null));
        this.processNullExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setCloneOriginalEvent(Boolean.valueOf(false));
        this.processor.setPayload(this.payload(null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidAttributesExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setAttributes(this.attributes(INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidErrorTypeIdExpression() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setError(this.error(INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidKeyExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidMediaTypeExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, INVALID_MEL_EXPRESSION, null));
        this.processInvalidExpression(originalEvent);
    }

    @Test(expected=MunitError.class)
    public void withInvalidEncodingExpressionInVariable() throws MuleException {
        InternalEvent originalEvent = this.buildSimpleEvent();
        this.processor.setVariables(this.variables(null, null, null, INVALID_MEL_EXPRESSION));
        this.processInvalidExpression(originalEvent);
    }

    @Test
    public void checkProcessorName() {
        SetEventProcessor mp = new SetEventProcessor();
        Assert.assertEquals((String)this.getExpectedName(), (String)mp.getProcessor());
    }

    private Payload payload(Object value) {
        Payload payload = new Payload();
        payload.setValue(value);
        return payload;
    }

    private Payload payload(String mediaType, String encoding) {
        Payload payload = new Payload();
        payload.setValue((Object)new NullObject());
        payload.setMediaType(mediaType);
        payload.setEncoding(encoding);
        return payload;
    }

    private Payload payload(Object value, String mediaType, String encoding) {
        Payload payload = new Payload();
        payload.setValue(value);
        payload.setMediaType(mediaType);
        payload.setEncoding(encoding);
        return payload;
    }

    private UntypedEventError error(String id) {
        UntypedEventError error = new UntypedEventError();
        error.setTypeId(id);
        return error;
    }

    private UntypedEventError error(String id, Throwable exception) {
        UntypedEventError error = new UntypedEventError();
        error.setTypeId(id);
        error.setCause((Object)exception);
        return error;
    }

    private EventAttributes attributes(Object value) {
        EventAttributes eventAttributes = new EventAttributes();
        eventAttributes.setValue(value);
        return eventAttributes;
    }

    private EventAttributes attributes(Object value, String mediaType, String encoding) {
        EventAttributes eventAttributes = new EventAttributes();
        eventAttributes.setValue(value);
        eventAttributes.setEncoding(encoding);
        eventAttributes.setMediaType(mediaType);
        return eventAttributes;
    }

    private List<Variable> variables(String key, Object value) {
        return this.variables(key, value, null, null);
    }

    private List<Variable> variables(String key, Object value, String mediaType, String encoding) {
        Variable v = new Variable();
        v.setKey(key);
        v.setValue(value);
        v.setMediaType(mediaType);
        v.setEncoding(encoding);
        return Stream.of(v).collect(Collectors.toList());
    }

    private InternalEvent buildSimpleEvent() {
        return (InternalEvent)this.eventBuilder().build();
    }

    private EventBuilder eventBuilder() {
        return new EventBuilder(this.eventContextMock);
    }

    private void processNonStringExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(NON_STRING_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(NON_STRING_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(1);
        Mockito.when((Object)this.expressionManagerMock.evaluate(NON_STRING_MEL_EXPRESSION, (CoreEvent)event)).thenReturn((Object)expressionResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void processNullExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(NULL_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(NULL_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(null);
        Mockito.when((Object)this.expressionManagerMock.evaluate(NULL_MEL_EXPRESSION, (CoreEvent)event)).thenReturn((Object)expressionResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void processInvalidExpression(InternalEvent event) throws MuleException {
        Mockito.when((Object)this.expressionManagerMock.isExpression(INVALID_MEL_EXPRESSION)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(false, "Invalid");
        Mockito.when((Object)this.expressionManagerMock.validate(INVALID_MEL_EXPRESSION)).thenReturn((Object)validationResultMock);
        this.processor.process((CoreEvent)event);
    }

    private void assertDataType(DataType dataType, String mediaType, String encoding) {
        DataType expectedDataType = DataType.builder((DataType)DataType.JSON_STRING).charset(Charset.forName(encoding)).build();
        this.assertDataType(dataType, mediaType, encoding, expectedDataType);
    }

    private void assertDataType(DataType dataType, String mediaType, String encoding, DataType expectedType) {
        DataType expected = DataType.builder().mediaType(mediaType).charset(encoding).build();
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType, (Matcher)Is.is((Object)expectedType));
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType.getMediaType().getPrimaryType(), (Matcher)Is.is((Object)expected.getMediaType().getPrimaryType()));
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)dataType.getMediaType().getSubType(), (Matcher)Is.is((Object)expected.getMediaType().getSubType()));
        MatcherAssert.assertThat((String)"DataType is not as expected", (Object)((Charset)dataType.getMediaType().getCharset().get()), (Matcher)Is.is((Object)Charset.forName(encoding)));
    }

    private void assertAttachment(DataHandler attachment, String value, String mediaType, String encoding) throws IOException {
        InputStream inputStream = attachment.getDataSource().getInputStream();
        int n = inputStream.available();
        byte[] bytes = new byte[n];
        inputStream.read(bytes, 0, n);
        String s = new String(bytes);
        MatcherAssert.assertThat((String)"Attachment content is not as expected", (Object)s, (Matcher)Is.is((Object)value));
        MatcherAssert.assertThat((Object)attachment.getDataSource().getContentType(), (Matcher)Is.is((Object)(mediaType + "; charset=" + encoding)));
    }

    private void mockEvaluateIfExpression(String exp, String expResult) {
        Mockito.when((Object)this.expressionManagerMock.isExpression(exp)).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManagerMock.isValid(exp)).thenReturn((Object)true);
        ValidationResult validationResultMock = this.validationResult(true, "");
        Mockito.when((Object)this.expressionManagerMock.validate(exp)).thenReturn((Object)validationResultMock);
        TypedValue expressionResultMock = this.expressionResult(expResult);
        Mockito.when((Object)this.expressionManagerMock.evaluate((String)ArgumentMatchers.eq((Object)exp), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)expressionResultMock);
    }

    private void verifyEvaluateIfExpression(String exp) {
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).isExpression(exp);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).validate(exp);
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManagerMock, (VerificationMode)Mockito.times((int)1))).evaluate((String)ArgumentMatchers.eq((Object)exp), (CoreEvent)ArgumentMatchers.any(CoreEvent.class));
    }

    private TypedValue expressionResult(Object value) {
        TypedValue expressionResult = new TypedValue(value, DataType.fromObject((Object)value));
        return expressionResult;
    }

    private ValidationResult validationResult(Boolean success, String error) {
        ValidationResult validationResultMock = (ValidationResult)Mockito.mock(ValidationResult.class);
        Mockito.when((Object)validationResultMock.isSuccess()).thenReturn((Object)success);
        Mockito.when((Object)validationResultMock.errorMessage()).thenReturn(Optional.of(error));
        return validationResultMock;
    }

    protected String getExpectedName() {
        return "set";
    }
}

