/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.model.Authentication;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.api.model.RepositoryPolicy;

class ImmutableRemoteRepository
implements RemoteRepository {
    private String id;
    private URL url;
    private Authentication authentication;
    private RepositoryPolicy releasePolicy;
    private RepositoryPolicy snapshotPolicy;

    public ImmutableRemoteRepository(String id, URL url, Optional<Authentication> authentication, RepositoryPolicy repositoryPolicy, RepositoryPolicy snapshotPolicy) {
        Objects.requireNonNull(id, "id cannot be null");
        Objects.requireNonNull(url, "url cannot be null");
        this.id = id;
        this.url = url;
        this.authentication = authentication.orElse(null);
        this.releasePolicy = repositoryPolicy;
        this.snapshotPolicy = snapshotPolicy;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return Optional.ofNullable(this.authentication);
    }

    @Override
    public Optional<RepositoryPolicy> getReleasePolicy() {
        return Optional.ofNullable(this.releasePolicy);
    }

    @Override
    public Optional<RepositoryPolicy> getSnapshotPolicy() {
        return Optional.ofNullable(this.snapshotPolicy);
    }

    public String toString() {
        return "ImmutableRemoteRepository{id='" + this.id + '\'' + ", url=" + this.url + ", authentication=" + this.authentication + ", releasePolicy=" + this.releasePolicy + ", snapshotPolicy=" + this.releasePolicy + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRemoteRepository that = (ImmutableRemoteRepository)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!Objects.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!Objects.equals(this.releasePolicy, that.releasePolicy)) {
            return false;
        }
        return Objects.equals(this.snapshotPolicy, that.snapshotPolicy);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + (this.authentication != null ? this.authentication.hashCode() : 0);
        result = 31 * result + (this.releasePolicy != null ? this.releasePolicy.hashCode() : 0);
        result = 31 * result + (this.snapshotPolicy != null ? this.snapshotPolicy.hashCode() : 0);
        return result;
    }
}

