/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.starter;

import java.io.IOException;
import java.lang.module.ModuleFinder;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.List;

import static java.lang.ModuleLayer.boot;
import static java.lang.ModuleLayer.defineModulesWithManyLoaders;
import static java.lang.Thread.currentThread;
import static java.lang.module.Configuration.resolve;
import static java.lang.module.ModuleFinder.ofSystem;
import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import java.util.Set;
import java.lang.reflect.Method;
import java.util.Arrays;

import java.lang.module.Configuration;


/**
 * Creates a Layer to avoid adding modules in the boot layer when running with java 17
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class LayerStarter {

  public static final String MODULE_PATH = "module_path";


  public static void main(String args[]) throws ParseException, IOException, URISyntaxException, ClassNotFoundException,
      NoSuchMethodException, java.lang.IllegalAccessException, java.lang.reflect.InvocationTargetException {
    for (int i = 0; i < args.length; i++) {
      if (args[i].equals("-" + MODULE_PATH)) {
        Path modulePath = Path.of(args[i + 1]);
        ModuleFinder finder = ModuleFinder.of(modulePath);
        ModuleLayer parent = ModuleLayer.boot();
        Configuration cf = parent.configuration().resolveAndBind(finder, ModuleFinder.of(), Set.of("munit.remote"));

        ClassLoader scl = ClassLoader.getSystemClassLoader();

        ModuleLayer layer = parent.defineModulesWithManyLoaders(cf, scl);
        Class<?> c = layer.findLoader("munit.remote").loadClass("org.mule.munit.remote.RemoteRunner");
        String runConfiguration = "";
        for (int j = 0; j < args.length; j++) {
          if (args[j].equals("-run_configuration")) {
            runConfiguration = args[j + 1];
          }
        }
        Method m = c.getDeclaredMethod("mainStarter", String.class);
        // currentThread().setContextClassLoader(layer.findLoader("munit.remote"));
        m.invoke(null, runConfiguration);

      }
    }
  }
}
