/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.util.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.mule.munit.runner.component.rules.TemporaryStorageRule;
import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.munit.tools.util.store.KeyAlreadyExistsException;
import org.mule.munit.tools.util.store.MissingKeyException;
import org.mule.munit.tools.util.store.RetrieveErrorProvider;
import org.mule.munit.tools.util.store.StoreErrorProvider;
import org.mule.munit.tools.util.store.StoreOAuthTokenErrorProvider;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.oauth.api.state.DefaultResourceOwnerOAuthContext;

public class StorageOperations {
    @Inject
    protected TemporaryStorageRule storageRule;

    @Summary(value="Stores the given data associated with the given key")
    @Throws(value={StoreErrorProvider.class})
    public void store(String key, @Optional(defaultValue="#[payload]") @Content TypedValue<Serializable> value, @Optional(defaultValue="false") boolean failIfPresent) {
        this.validateKey(key);
        if (failIfPresent) {
            this.storageRule.retrieve(key).ifPresent(previous -> {
                throw new KeyAlreadyExistsException(key);
            });
        }
        this.storageRule.store(key, value);
    }

    @Summary(value="Retrieves the data associated with the given key")
    @Throws(value={RetrieveErrorProvider.class})
    public Result<Serializable, Void> retrieve(String key) {
        this.validateKey(key);
        return this.asResult(this.storageRule.retrieve(key).orElseThrow(() -> new MissingKeyException(key)));
    }

    @Summary(value="Removes the data associated with the given key")
    @Throws(value={RetrieveErrorProvider.class})
    public Result<Serializable, Void> remove(String key) {
        this.validateKey(key);
        return this.asResult(this.storageRule.remove(key).orElseThrow(() -> new MissingKeyException(key)));
    }

    @Summary(value="Clears all stored data")
    public void clearStoredData() {
        this.storageRule.clear();
    }

    private Result<Serializable, Void> asResult(Object value) {
        TypedValue typedValue = value instanceof TypedValue ? (TypedValue)value : new TypedValue((Object)((Serializable)value), DataType.fromType(value.getClass()));
        return Result.builder().output((Object)((Serializable)typedValue.getValue())).mediaType(typedValue.getDataType().getMediaType()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Alias(value="store-oauth-token")
    @Throws(value={StoreOAuthTokenErrorProvider.class})
    public void storeOAuthToken(String accessToken, @ParameterDsl(allowInlineDefinition=false) ObjectStore objectStore, @Optional(defaultValue="") String ownerConfigName, @Optional(defaultValue="") String resourceOwnerId, @Optional String refreshToken, @Optional String expiresIn, @Optional String state, @Optional @Content Map<String, Object> additionalParameters, @Optional(defaultValue="true") boolean overwrite) throws ObjectStoreException {
        DefaultResourceOwnerOAuthContext ctx = new DefaultResourceOwnerOAuthContext((Lock)new ReentrantLock(), resourceOwnerId);
        ctx.setAccessToken(accessToken);
        ctx.setRefreshToken(refreshToken);
        ctx.setExpiresIn(expiresIn);
        ctx.setState(state);
        ctx.setTokenResponseParameters(additionalParameters);
        String key = resourceOwnerId + "-" + ownerConfigName;
        ObjectStore objectStore2 = objectStore;
        synchronized (objectStore2) {
            if (objectStore.contains(key)) {
                if (overwrite) {
                    objectStore.remove(key);
                } else {
                    throw new ModuleException(String.format("An entry already exists for key '%s' in the Object Store", key), (ErrorTypeDefinition)MunitToolsErrorDefinition.KEY_ALREADY_EXISTS);
                }
            }
            objectStore.store(key, (Serializable)ctx);
        }
    }

    private void validateKey(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new ModuleException((ErrorTypeDefinition)MunitToolsErrorDefinition.INVALID_KEY, (Throwable)new IllegalArgumentException("Key cannot be null nor empty"));
        }
    }
}

