/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

/**
 * Utility functions to handle mule resources
 *
 * @since 2.2.0
 * @author Mulesoft Inc.
 */

public class MuleComponentsFunctions {

  public static Message createMessage(Object payload, String mimeType, Object attributes, String attributesMimeType) {
    return Message.builder()
        .payload(getTypedValue(payload, mimeType))
        .attributes(getTypedValue(attributes, attributesMimeType))
        .build();
  }

  private static TypedValue getTypedValue(Object obj, String mimeType) {
    if (mimeType == null) {
      return TypedValue.of(obj);
    } else {
      DataType dataType = DataType.builder().mediaType(mimeType).build();
      return new TypedValue<>(obj, dataType);
    }
  }
}
