/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.store;

import static java.lang.String.format;

import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * {@link ModuleException} when key not found in storage
 * 
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class MissingKeyException extends ModuleException {

  public MissingKeyException(String key) {
    super(format("Unable to find key: %s", key), MunitToolsErrorDefinition.MISSING_KEY);
  }
}
