/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class AssertionComparisonMatchersTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/comparison-matchers.xml";
  }

  @Test
  public void greaterThan() throws Exception {
    runFlow("greaterThan");
  }

  @Test
  public void greaterThanFail() throws Exception {
    runExpectingAssertionError("greaterThanFail");
  }

  @Test
  public void greaterThanOrEqualTo() throws Exception {
    runFlow("greaterThanOrEqualTo");
  }

  @Test
  public void greaterThanOrEqualToFail() throws Exception {
    runExpectingAssertionError("greaterThanOrEqualToFail");
  }

  @Test
  public void lessThan() throws Exception {
    runFlow("lessThan");
  }

  @Test
  public void lessThanFail() throws Exception {
    runExpectingAssertionError("lessThanFail");
  }

  @Test
  public void lessThanOrEqualTo() throws Exception {
    runFlow("lessThanOrEqualTo");
  }

  @Test
  public void lessThanOrEqualToFail() throws Exception {
    runExpectingAssertionError("lessThanOrEqualToFail");
  }

  @Test
  public void closeTo() throws Exception {
    runFlow("closeTo");
  }

  @Test
  public void closeToFail() throws Exception {
    runExpectingAssertionError("closeToFail");
  }

}
