/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class AssertionCoreMatchersTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/core-matchers.xml";
  }

  @Test
  public void equalToBoolean() throws Exception {
    runFlow("equalToBoolean");
  }

  @Test
  public void equalToInteger() throws Exception {
    runFlow("equalToInteger");
  }

  @Test
  public void equalToString() throws Exception {
    runFlow("equalToString");
  }

  @Test
  public void equalToPayload() throws Exception {
    runFlow("equalToPayload");
  }

  @Test
  public void equalToVariable() throws Exception {
    runFlow("equalToVariable");
  }

  @Test
  public void equalToStructure() throws Exception {
    runFlow("equalToStructure");
  }

  @Test
  public void equalToStructureFromFile() throws Exception {
    runFlow("equalToStructureFromFile");
  }

  @Test
  public void equalToStructureUnordered() throws Exception {
    runFlow("equalToStructureUnordered");
  }

  @Test
  public void equalToFail() throws Exception {
    runExpectingAssertionError("equalToFail");
  }

  @Test
  public void nullValue() throws Exception {
    runFlow("nullValue");
  }

  @Test
  public void notNullValue() throws Exception {
    runFlow("notNullValue");
  }

  @Test
  public void notEqualTo() throws Exception {
    runFlow("notEqualTo");
  }

  @Test
  public void notWithValue() throws Exception {
    runFlow("notWithValue");
  }

  @Test
  public void bothEqualToAndNotNull() throws Exception {
    runFlow("bothEqualToAndNotNull");
  }

  @Test
  public void eitherEqualToAndNotNull() throws Exception {
    runFlow("eitherEqualToAndNotNull");
  }

  @Test
  public void withISOEncoding() throws Exception {
    runFlow("withISOEncoding");
  }

  @Test
  public void withTextXmlMediaType() throws Exception {
    runFlow("withTextXmlMediaType");
  }

  @Test
  public void allOf() throws Exception {
    runFlow("allOf");
  }

  @Test
  public void anyOf() throws Exception {
    runFlow("anyOf");
  }

}
