/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.assertion;

import org.junit.Test;

public class AssertionIterableMatchersTestCase extends AssertionTestCase {

  @Override
  protected String getConfigFile() {
    return "assertion/iterable-matchers.xml";
  }

  @Test
  public void everyItem() throws Exception {
    runFlow("everyItem");
    runFlow("iteratorEveryItem");
  }

  @Test
  public void everyItemFail() throws Exception {
    runExpectingAssertionError("everyItemFail");
    runExpectingAssertionError("iteratorEveryItemFail");
  }

  @Test
  public void hasItem() throws Exception {
    runFlow("hasItem");
    runFlow("iteratorHasItem");
  }

  @Test
  public void hasItemWithValue() throws Exception {
    runFlow("hasItemWithValue");
    runFlow("iteratorHasItemWithValue");
  }

  @Test
  public void hasItemFail() throws Exception {
    runExpectingAssertionError("hasItemFail");
    runExpectingAssertionError("iteratorHasItemFail");
  }

  @Test
  public void hasSize() throws Exception {
    runFlow("hasSize");
    runFlow("iteratorHasSize");
  }

  @Test
  public void hasSizeWithNumber() throws Exception {
    runFlow("hasSizeWithNumber");
    runFlow("iteratorHasSizeWithNumber");
  }

  @Test
  public void hasSizeFail() throws Exception {
    runExpectingAssertionError("hasSizeFail");
    runExpectingAssertionError("iteratorHasSizeFail");
  }

  @Test
  public void hasSizeNull() throws Exception {
    runExpectingAssertionError("hasSizeNull");
  }

  @Test
  public void hasSizeNullWithNumber() throws Exception {
    runExpectingAssertionError("hasSizeNullWithNumber");
  }

  @Test
  public void isEmpty() throws Exception {
    runFlow("isEmpty");
    runFlow("iteratorIsEmpty");
  }

  @Test
  public void isEmptyFail() throws Exception {
    runExpectingAssertionError("isEmptyFail");
    runExpectingAssertionError("iteratorIsEmptyFail");
  }

  @Test
  public void hasKey() throws Exception {
    runFlow("hasKey");
  }

  @Test
  public void hasKeyWithString() throws Exception {
    runFlow("hasKeyWithString");
  }

  @Test
  public void hasKeyFail() throws Exception {
    runExpectingAssertionError("hasKeyFail");
  }

  @Test
  public void hasKeyNull() throws Exception {
    runExpectingAssertionError("hasKeyNull");
  }

  @Test
  public void hasValue() throws Exception {
    runFlow("hasValue");
  }

  @Test
  public void hasValueWithLiteral() throws Exception {
    runFlow("hasValueWithLiteral");
  }

  @Test
  public void hasValueFail() throws Exception {
    runExpectingAssertionError("hasValueFail");
  }

  @Test
  public void hasValueNull() throws Exception {
    runExpectingAssertionError("hasValueNull");
  }

  @Test
  public void hasValueNullWithLiteral() throws Exception {
    runExpectingAssertionError("hasValueNullWithLiteral");
  }

}
