/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.mock;

import static java.util.Collections.singletonList;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mule.munit.tools.mock.StreamingUtils.resolveCursorProviders;
import org.mule.munit.common.api.model.Event;
import org.mule.munit.common.api.model.EventAttributes;
import org.mule.munit.common.api.model.Payload;
import org.mule.munit.common.api.model.Variable;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

import org.junit.Before;
import org.junit.Test;

public class StreamingUtilsTest {

  private Event event;
  private StreamingHelper streamingHelperMock;
  private static final String EXAMPLE_VALUE = "EXAMPLE_VALUE";

  @Before
  public void setUp() {
    streamingHelperMock = mock(StreamingHelper.class);
    event = new Event();
  }

  @Test
  public void payloadIsResolved() {
    Payload payload = new Payload();
    payload.setValue(EXAMPLE_VALUE);
    event.setPayload(payload);

    resolveCursorProviders(streamingHelperMock, event);

    verify(streamingHelperMock).resolveCursorProvider(EXAMPLE_VALUE);
  }

  @Test
  public void attributesAreResolved() {
    EventAttributes attributes = new EventAttributes();
    attributes.setValue(EXAMPLE_VALUE);
    event.setAttributes(attributes);

    resolveCursorProviders(streamingHelperMock, event);

    verify(streamingHelperMock).resolveCursorProvider(EXAMPLE_VALUE);
  }

  @Test
  public void variablesAreResolved() {
    Variable variable = new Variable();
    variable.setValue(EXAMPLE_VALUE);
    event.setVariables(singletonList(variable));

    resolveCursorProviders(streamingHelperMock, event);

    verify(streamingHelperMock).resolveCursorProvider(EXAMPLE_VALUE);
  }

}
