/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;

import static org.hamcrest.CoreMatchers.*;
import static org.hamcrest.MatcherAssert.assertThat;

public class MuleComponentsFunctionsTest {

  private static final String PAYLOAD_VALUE = "payload_value";

  private MuleComponentsFunctions functions;

  @Before
  public void setUp() {
    functions = new MuleComponentsFunctions();
  }

  @Test
  public void createMessageWithoutMimeType() {
    Message message = functions.createMessage(PAYLOAD_VALUE, null, null, null);

    assertThat("Payload  is not as expected", message.getPayload().getValue(), is(PAYLOAD_VALUE));
    assertThat("DataType is not as expected", message.getPayload().getDataType().getMediaType(),
               is(DataType.MULE_MESSAGE.getMediaType()));
    assertThat("Attributes are not as expected", message.getAttributes().getValue(), is(nullValue()));
  }

  @Test
  public void createMessageWithoutAttributes() {
    Message message = functions.createMessage(PAYLOAD_VALUE, DataType.JSON_STRING.getMediaType().toString(), null, null);

    assertThat("Payload  is not as expected", message.getPayload().getValue(), is(PAYLOAD_VALUE));
    assertThat("DataType is not as expected", message.getPayload().getDataType().getMediaType(),
               is(DataType.JSON_STRING.getMediaType()));
    assertThat("Attributes are not as expected", message.getAttributes().getValue(), is(nullValue()));
  }

  @Test
  public void createMessageWithAttribute() {
    Message message =
        functions.createMessage(PAYLOAD_VALUE, DataType.JSON_STRING.getMediaType().toString(), "{ 'name': 'test' }", null);

    assertThat("Payload  is not as expected", message.getPayload().getValue(), is(PAYLOAD_VALUE));
    assertThat("DataType is not as expected", message.getPayload().getDataType().getMediaType(),
               is(DataType.JSON_STRING.getMediaType()));
    assertThat("Attributes are not as expected", message.getAttributes().getValue(), equalTo("{ 'name': 'test' }"));
  }

  @Test
  public void createMessageWithMimetypeAttribute() {
    Message message = functions.createMessage(PAYLOAD_VALUE, DataType.JSON_STRING.getMediaType().toString(), "{ 'name': 'test' }",
                                              "application/json");

    assertThat("Payload  is not as expected", message.getPayload().getValue(), is(PAYLOAD_VALUE));
    assertThat("DataType is not as expected", message.getPayload().getDataType().getMediaType(),
               is(DataType.JSON_STRING.getMediaType()));
    assertThat("Attributes are not as expected", message.getAttributes().getValue(), equalTo("{ 'name': 'test' }"));
    assertThat("Attributes MimeType is not as expected", message.getAttributes().getDataType().getMediaType(),
               is(DataType.JSON_STRING.getMediaType()));
  }

  @Test
  public void createWithoutMimeTypeMessageAndAttributes() {
    Message message = functions.createMessage(PAYLOAD_VALUE, null, "{ 'name': 'test' }", null);

    assertThat("Payload  is not as expected", message.getPayload().getValue(), is(PAYLOAD_VALUE));
    assertThat("DataType is not as expected", message.getPayload().getDataType().getMediaType(),
               is(DataType.MULE_MESSAGE.getMediaType()));
    assertThat("Attributes are not as expected", message.getAttributes().getValue(), equalTo("{ 'name': 'test' }"));
    assertThat("Attributes MimeType is not as expected", message.getAttributes().getDataType().getMediaType(),
               is(DataType.MULE_MESSAGE.getMediaType()));
  }

}
